/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.util.ArrayList;

public enum AppType {
    SINGLE_INSTANCE("single-instance", "Single Instance (Elastic IP)", true, true),
    LOAD_BALANCED_HTTPS("load-balanced-https", "Load Balanced HTTPS (ALB + Auto-Scaling)", true, true),
    LOAD_BALANCED("load-balanced", "Load Balanced (Classic ELB + Auto-Scaling)", true, true),
    WORKER("worker", "Worker (Auto-Scaling)", false, true),
    ONE_OFF("one-off", "One-off", false, false);

    private final String name;
    private final String description;
    private final boolean dns;
    private final boolean dbSnapshotCreateRestore;

    private AppType(String name, String description, boolean dns, boolean dbSnapshotCreateRestore) {
        this.name = name;
        this.description = description;
        this.dns = dns;
        this.dbSnapshotCreateRestore = dbSnapshotCreateRestore;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDns() {
        return this.dns;
    }

    public boolean isDbSnapshotCreateRestore() {
        return this.dbSnapshotCreateRestore;
    }

    public String toString() {
        return this.name;
    }

    public static AppType of(String name) {
        if (name == null) {
            return null;
        }
        return AppType.fromName(name);
    }

    private static AppType fromName(String name) {
        if (name == null) {
            return SINGLE_INSTANCE;
        }
        for (AppType appType : AppType.values()) {
            if (!appType.name.equals(name)) continue;
            return appType;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AppType type : AppType.values()) {
            names.add(type.getName());
        }
        throw new BoxfuseException("Invalid app type: " + name + " (Possible values: " + StringUtils.collectionToDelimitedString(names, ", ") + ")");
    }
}

