/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;

public enum TlsType {
    NONE("none", "No automatic TLS (SSL) certificate management", AppType.values()),
    ACM("acm", "Automatic TLS (SSL) certificates with AWS Certificate Manager", AppType.LOAD_BALANCED_HTTPS, AppType.LOAD_BALANCED);

    private final String name;
    private final String description;
    private final AppType[] supportedAppTypes;

    private TlsType(String name, String description, AppType ... supportedAppTypes) {
        this.name = name;
        this.description = description;
        this.supportedAppTypes = supportedAppTypes;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static TlsType of(String name) {
        if (name == null) {
            return null;
        }
        return TlsType.fromName(name);
    }

    @JsonCreator
    public static TlsType fromName(String name) {
        if (name == null) {
            return NONE;
        }
        for (TlsType logsType : TlsType.values()) {
            if (!logsType.name.equals(name)) continue;
            return logsType;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (TlsType type : TlsType.values()) {
            names.add(type.getName());
        }
        throw new BoxfuseException("Invalid tls type: " + name + " (Possible values: " + StringUtils.collectionToDelimitedString(names, ", ") + ")");
    }

    public boolean supports(AppType appType) {
        return Arrays.asList(this.supportedAppTypes).contains((Object)appType);
    }

    public void ensureSupports(AppType appType) {
        if (!this.supports(appType)) {
            throw new BoxfuseException(this.getDescription() + " is not supported for " + (Object)((Object)appType) + " apps\n=> (re)create your app with its type set to one of the following: " + StringUtils.arrayToDelimitedString((Object[])this.supportedAppTypes, ", "));
        }
    }
}

