/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.port;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Protocol;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.List;

public class PortName
implements Comparable<PortName> {
    public static final PortName HTTP = new PortName("http", Protocol.HTTP, 80);
    public static final PortName HTTPS = new PortName("https", Protocol.HTTPS, 443);
    public static final PortName ADMIN_HTTP = new PortName("admin-http", Protocol.HTTP, 80);
    public static final PortName ADMIN_HTTPS = new PortName("admin-https", Protocol.HTTPS, 443);
    public static final PortName DEBUG = new PortName("debug");
    public static final PortName JMX = new PortName("jmx");
    private final String name;
    private final Protocol protocol;
    private final Integer defaultPortNumber;

    private PortName(String name) {
        this(name, Protocol.TCP, null);
    }

    private PortName(String name, Protocol protocol, Integer defaultPortNumber) {
        if ("".equals(name)) {
            throw new BoxfuseException("Port name may not be empty");
        }
        if (!name.matches("[a-z][a-z\\-]*")) {
            throw new BoxfuseException("Port name may only contain a-z and single dashes (-) but was " + name);
        }
        if (name.endsWith("-")) {
            throw new BoxfuseException("Port name may not end with a dash but was " + name);
        }
        if (name.contains("--")) {
            throw new BoxfuseException("Port name may not contain double dashes but was " + name);
        }
        this.name = name;
        this.protocol = protocol;
        this.defaultPortNumber = defaultPortNumber;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public Integer getDefaultPortNumber() {
        return this.defaultPortNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortName portName = (PortName)o;
        return this.name.equals(portName.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(PortName o) {
        return this.name.compareTo(o.name);
    }

    @JsonCreator
    public static PortName of(String portName) {
        if (portName == null) {
            return null;
        }
        List<PortName> standardPortNames = Arrays.asList(HTTP, HTTPS, ADMIN_HTTP, ADMIN_HTTPS, DEBUG, JMX);
        for (PortName standardPortName : standardPortNames) {
            if (!standardPortName.getName().equals(portName)) continue;
            return standardPortName;
        }
        return new PortName(portName);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }
}

