/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/boxfuse/base/types/EnvName;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "Companion", "boxfuse-base-core"})
public final class EnvName
implements Comparable<EnvName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private static final int MAX_LENGTH = 64;
    @NotNull
    public static final String REGEX_PATTERN = "^(?=.{1,64}$)[a-z](-?[a-z0-9]+)*$";
    @NotNull
    private static final Regex REGEX = new Regex("^(?=.{1,64}$)[a-z](-?[a-z0-9]+)*$");
    @JvmField
    @NotNull
    public static final EnvName DEV = new EnvName("dev");
    @JvmField
    @NotNull
    public static final EnvName TEST = new EnvName("test");
    @JvmField
    @NotNull
    public static final EnvName PROD = new EnvName("prod");

    private EnvName(String name) {
        if (!REGEX.matches(name)) {
            throw new BoxfuseException(Intrinsics.stringPlus("Invalid environment name (may only contain a-z, 0-9 and single dashes in between, max 64 chars): ", name));
        }
        this.name = name;
    }

    @JsonValue
    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return Intrinsics.areEqual(this.name, ((EnvName)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(@NotNull EnvName other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.name.compareTo(other.name);
    }

    @JvmStatic
    public static final boolean validate(@Nullable String name) {
        return Companion.validate(name);
    }

    @JsonCreator
    @JvmStatic
    @Nullable
    public static final EnvName of(@Nullable String value) {
        return Companion.of(value);
    }

    public /* synthetic */ EnvName(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/boxfuse/base/types/EnvName$Companion;", "", "()V", "DEV", "Lcom/boxfuse/base/types/EnvName;", "MAX_LENGTH", "", "PROD", "REGEX", "Lkotlin/text/Regex;", "REGEX_PATTERN", "", "TEST", "of", "value", "validate", "", "name", "boxfuse-base-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean validate(@Nullable String name) {
            return name == null ? false : REGEX.matches(name);
        }

        @JsonCreator
        @JvmStatic
        @Nullable
        public final EnvName of(@Nullable String value) {
            if (value == null) {
                return null;
            }
            if (Intrinsics.areEqual(DEV.getName(), value)) {
                return DEV;
            }
            if (Intrinsics.areEqual(TEST.getName(), value)) {
                return TEST;
            }
            if (Intrinsics.areEqual(PROD.getName(), value)) {
                return PROD;
            }
            return new EnvName(value, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

