/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.util.EnvironmentUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BusyIndicator {
    private static final String[] PROGRESS_CHARS = new String[]{"/", "-", "\\", "|"};
    private int state;
    private ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public void start() {
        if (!EnvironmentUtils.isRunningInCi() && !EnvironmentUtils.isOutputMachineReadable()) {
            this.ses.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    BusyIndicator.this.state++;
                    BusyIndicator.this.state = BusyIndicator.this.state % PROGRESS_CHARS.length;
                    System.out.print("\r" + PROGRESS_CHARS[BusyIndicator.this.state] + "\r");
                }
            }, 0L, 250L, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (!EnvironmentUtils.isRunningInCi() && !EnvironmentUtils.isOutputMachineReadable()) {
            this.ses.shutdown();
            System.out.print("\r \r");
        }
    }
}

