/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorUtils.class);
    private static Integer cpus;

    private ProcessorUtils() {
    }

    public static int getNumberOfPhysicalProcessorCores() {
        if (cpus == null) {
            try {
                if (OSUtils.runningOnWindows()) {
                    String rawOutput = ShellUtils.execCommand("wmic", "cpu", "get", "NumberOfCores", "/Format:List").trim();
                    cpus = Integer.parseInt(rawOutput.substring(rawOutput.lastIndexOf("=") + 1));
                } else if (OSUtils.runningOnMac()) {
                    String rawOutput = ShellUtils.execCommand("sysctl", "hw.physicalcpu").trim();
                    cpus = Integer.parseInt(rawOutput.substring(rawOutput.lastIndexOf(":") + 1).trim());
                } else {
                    String rawOutput = ShellUtils.execCommand("/bin/sh", "-c", "grep -i \"processor\" /proc/cpuinfo | wc -l");
                    cpus = Integer.parseInt(rawOutput.trim());
                }
                if (cpus == 0) {
                    LOGGER.debug("OS reported an invalid number of physical CPUs (0) => defaulting to 1");
                    cpus = 1;
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to determine number of CPUs in host machine (Defaulting to 1): " + e.getMessage());
                cpus = 1;
            }
        }
        return cpus;
    }
}

