/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core;

import com.boxfuse.base.aws.AwsSubnetId;
import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.crypto.CryptoUtils;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.types.Capacity;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.BusyIndicator;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ThreadUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.client.core.BoxfuseConnectConfig;
import com.boxfuse.client.core.api.command.AppResult;
import com.boxfuse.client.core.api.command.AwsResult;
import com.boxfuse.client.core.api.command.ConvertResult;
import com.boxfuse.client.core.api.command.DbResult;
import com.boxfuse.client.core.api.command.FuseResult;
import com.boxfuse.client.core.api.command.ImageResult;
import com.boxfuse.client.core.api.command.InstanceResult;
import com.boxfuse.client.core.api.command.RunResult;
import com.boxfuse.client.core.internal.cache.ActivationCache;
import com.boxfuse.client.core.internal.cloudwatchlogs.CloudwatchLogsAwsLogs;
import com.boxfuse.client.core.internal.cloudwatchlogs.CloudwatchLogsMockLogs;
import com.boxfuse.client.core.internal.console.AppInfo;
import com.boxfuse.client.core.internal.console.Console;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.client.core.internal.platform.AsciiTableInfo;
import com.boxfuse.client.core.internal.platform.DevVM;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.LaunchResult;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.client.core.internal.platform.local.LocalPlatform;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformFactory;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformHealth;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVInstallation;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxInstallation;
import com.boxfuse.client.core.privateuse.util.LogsUtils;
import com.boxfuse.generator.Generator;
import com.boxfuse.generator.app.App;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.LogsFilters;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.image.spec.ImageSpec;
import com.boxfuse.generator.image.spec.ImageSpecValidator;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import com.boxfuse.generator.repository.Repository;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Boxfuse {
    public static final String BOXFUSE_MACHINEREADABLE_LOGGER_NAME = "boxfuse.machinereadable";
    private static final Logger MACHINE_READABLE_LOGGER = LoggerFactory.getLogger((String)"boxfuse.machinereadable");
    private static final Logger LOGGER = LoggerFactory.getLogger(Boxfuse.class);
    private static final String BOXFUSE_DEV_HDD_VERSION = "2016.02.09";
    private static final Locale ORIGINAL_LOCALE = Locale.getDefault();
    private final File cacheDir;
    private final File workDir;
    private final Console console;
    private final Inventory inventory;
    private final Repository repository;
    private final CertificateManager certificateManager;
    private final DevAgent devAgent;
    private final LocalPlatformFactory localPlatformFactory;
    private final boolean machineReadable;
    private final Proxy proxy;
    private final boolean insecure;

    public Boxfuse(BoxfuseConnectConfig connectConfig) {
        this(connectConfig, "API", true, false);
    }

    public Boxfuse(BoxfuseConnectConfig connectConfig, String client, boolean printVersion, boolean offline) {
        boolean commandline;
        if (printVersion) {
            Boxfuse.printVersion();
        }
        this.machineReadable = commandline = "CommandLine".equals(client);
        File baseDir = connectConfig.basedir.get();
        this.cacheDir = new File(baseDir.getAbsolutePath() + "/cache");
        this.workDir = new File(baseDir.getAbsolutePath() + "/work");
        this.proxy = connectConfig.proxy.get();
        if (this.proxy != null) {
            LOGGER.debug("Proxy: " + this.proxy.getProtocol() + "://" + this.proxy.getHost() + ":" + this.proxy.getPort());
        }
        this.insecure = connectConfig.insecure.get();
        if (connectConfig.console.isSet()) {
            System.setProperty("boxfuse.console", connectConfig.console.get());
        }
        this.console = this.createConsole(connectConfig, client, offline);
        this.certificateManager = this.console;
        this.inventory = this.createInventory();
        this.repository = this.createRepository();
        this.devAgent = this.createDevAgent();
        this.localPlatformFactory = new LocalPlatformFactory(this.workDir, this.repository, this.devAgent, this.console, connectConfig.platform.get());
        LOGGER.info("Account: " + this.console.getOwner() + " (" + this.console.getName() + ")" + (this.console.isOnline() ? "" : " [offline mode]"));
        LOGGER.info("");
        List<Map<String, String>> messages = this.console.getMessages();
        if (!messages.isEmpty()) {
            for (Map<String, String> message : messages) {
                String severity = message.get("severity");
                String text = message.get("text");
                if ("WARN".equals(severity)) {
                    LOGGER.warn("WARNING: " + text);
                    continue;
                }
                LOGGER.info(text);
            }
            LOGGER.info("");
        }
        if (this.console.getUpdateVersion() != null) {
            LOGGER.info("CloudCaptain Client " + this.console.getUpdateVersion() + " upgrade available." + (commandline ? " Simply update with \"boxfuse -u\"." : ""));
            LOGGER.info("");
        }
        LOGGER.debug("Cache Directory: " + this.cacheDir.getAbsolutePath());
        LOGGER.debug("Work  Directory: " + this.workDir.getAbsolutePath());
    }

    private DevAgent createDevAgent() {
        return new DevAgent(this.workDir);
    }

    Repository createRepository() {
        ShellUtils.mkdir(this.workDir);
        return new Repository(this.console, this.console.getOwner(), this.proxy, this.insecure, new File(this.workDir.getAbsolutePath(), "Images"));
    }

    Inventory createInventory() {
        return new Inventory(this.console, this.proxy, this.insecure, new File(this.cacheDir.getAbsolutePath(), "Components"));
    }

    Console createConsole(BoxfuseConnectConfig connectConfig, String client, boolean offline) {
        ActivationCache activationCache = new ActivationCache(new File(this.cacheDir.getAbsolutePath(), "Components"));
        return new Console(activationCache, connectConfig.user.get(), connectConfig.secret.get(), this.createUserAgent(client), offline, this.proxy, this.insecure);
    }

    private String createUserAgent(String client) {
        String os = System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + ORIGINAL_LOCALE.getLanguage() + "_" + ORIGINAL_LOCALE.getCountry();
        String javaVersion = System.getProperty("java.runtime.version");
        VirtualBoxInstallation details = VirtualBoxInstallation.get();
        boolean working = details.getHealth() == LocalPlatformHealth.OK || details.getHealth() == LocalPlatformHealth.OUTDATED;
        String virtualBoxVersion = working ? details.getRawVersion() : details.getHealth().toString();
        return "Boxfuse/" + BoxfuseConfig.VERSION + " " + client + " (" + os + ") Java/" + javaVersion + (virtualBoxVersion == null ? "" : " VirtualBox/" + virtualBoxVersion) + (OSUtils.runningOnWindows() ? " Hyper-V/" + (Object)((Object)HyperVInstallation.get().getHealth()) : "");
    }

    public static void printVersion() {
        String title = "CloudCaptain Client (previously called Boxfuse) v." + BoxfuseConfig.VERSION;
        LOGGER.info(title);
        LOGGER.info("Copyright 2026 InfrastructureX GmbH. All rights reserved.");
        LOGGER.info("");
    }

    public BoxfuseConfig createConfig() {
        return new BoxfuseConfig(this.console.getOwner());
    }

    public void inventory(BoxfuseConfig config) {
        LOGGER.info(this.inventoryAsString(config));
    }

    public String inventoryAsString(BoxfuseConfig config) {
        this.logConfig(config);
        ComponentId componentId = config.component.get();
        return new AsciiTableInfo().listComponents(this.inventory.versions(componentId), componentId, this.console.isOnline());
    }

    private void logConfig(BoxfuseConfig config) {
        LOGGER.debug("");
        LOGGER.debug("Using configuration:");
        for (Map.Entry<String, String> entry : config.toMap().entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
        LOGGER.debug("");
    }

    public FuseResult fuse(BoxfuseConfig config) {
        this.logConfig(config);
        ImageSpecImpl imageSpec = this.createImageSpec(config);
        Image image = this.fuse(imageSpec, config);
        if (config.vault.get().booleanValue()) {
            this.repository.push(image);
        }
        return new FuseResult(new ImageResult(image.getCoordinates().toString()));
    }

    private Image fuse(ImageSpecImpl imageSpec, BoxfuseConfig config) {
        Version version;
        int fingerprint;
        Image image;
        if (imageSpec.getPayload() == null) {
            throw new BoxfuseBugException("Unable to fuse Image! Payload is null!");
        }
        ImageCoordinates coordinates = imageSpec.getCoordinates();
        AppCoordinates appCoordinates = coordinates.getAppCoordinates();
        if (!this.console.getOwner().equals(coordinates.getOwner())) {
            throw new BoxfuseException("Unable to fuse image for different owner (" + coordinates.getOwner() + ")\n=> try setting the image to " + appCoordinates.getName() + ":" + coordinates.getVersion() + " instead\n=> try referring to a payload (jar, war, zip file) instead");
        }
        Generator generator = this.createGenerator(imageSpec);
        if (!this.appExists(appCoordinates)) {
            AppType appType = config.appType.get();
            TlsType tlsType = config.tlsType.get();
            DbType dbType = imageSpec.getDbType();
            LogsType logsType = config.logs.type.get();
            this.doCreate(appCoordinates, appType, tlsType, dbType, logsType);
        }
        if ((image = this.repository.findLocally(fingerprint = generator.fingerprint())) != null) {
            LOGGER.info("Found matching local image: " + image.getCoordinates());
            return image;
        }
        if (coordinates.getVersion() == null) {
            coordinates = new ImageCoordinates(appCoordinates, imageSpec.getPayload().extractVersion(true));
        }
        if (this.repository.findLocally(coordinates) != null) {
            version = Version.generateFallbackVersion();
            LOGGER.warn("WARNING: There is already another Image called " + coordinates + " => generating a new fallback version: " + version);
            imageSpec.setCoordinates(new ImageCoordinates(appCoordinates, version));
        } else if (this.repository.existsInVault(coordinates)) {
            version = Version.generateFallbackVersion();
            LOGGER.warn("WARNING: There is already another Image in the Vault called " + coordinates + " => generating a new fallback version: " + version);
            imageSpec.setCoordinates(new ImageCoordinates(appCoordinates, version));
        } else {
            imageSpec.setCoordinates(coordinates);
        }
        return generator.generate(this.workDir);
    }

    private int getFingerprint(ImageSpecImpl imageSpec) {
        return this.createGenerator(imageSpec).fingerprint();
    }

    private Generator createGenerator(ImageSpecImpl imageSpec) {
        PrivateKey privateKey = CryptoUtils.rsaPrivateKey(ByteArrayUtils.fromHex(this.console.getPrivateKey()));
        return new Generator(this.certificateManager, this.inventory, this.repository, privateKey, imageSpec);
    }

    public void ls(BoxfuseConfig config) {
        LOGGER.info(this.lsAsString(config));
    }

    public String lsAsString(BoxfuseConfig config) {
        this.logConfig(config);
        if (config.vault.get().booleanValue()) {
            AppCoordinates appCoordinates;
            if (!this.console.isOnline()) {
                throw new BoxfuseException("You must be online to query the Boxfuse Vault => check your internet connection and try again.");
            }
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, true, false, false, false);
            if (imageCoordinates != null) {
                if (imageCoordinates.getVersion() != null) {
                    return new AsciiTableInfo().listVaultImages(this.console.getApps(), imageCoordinates);
                }
                appCoordinates = imageCoordinates.getAppCoordinates();
            } else {
                appCoordinates = this.getAppCoordinates(config, false);
            }
            if (appCoordinates != null) {
                return new AsciiTableInfo().listVaultImages(this.console.getApps(), appCoordinates);
            }
            return new AsciiTableInfo().listVaultImages(this.console.getApps());
        }
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, true, false, false, false, false);
        if (imageCoordinates != null) {
            return new AsciiTableInfo().listLocalImages(this.repository.findAllLocally(imageCoordinates.getAppCoordinates(), imageCoordinates.getVersion()), imageCoordinates.toString());
        }
        AppCoordinates appCoordinates = this.getAppCoordinates(config, false);
        if (appCoordinates != null) {
            return new AsciiTableInfo().listLocalImages(this.repository.findAllLocally(appCoordinates, null), appCoordinates.toString());
        }
        return new AsciiTableInfo().listLocalImages(this.repository.findAllLocally(), null);
    }

    public void rm(BoxfuseConfig config) {
        this.logConfig(config);
        if (config.vault.get().booleanValue()) {
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, true, false, true, false);
            if (imageCoordinates != null) {
                Map<String, Object> result = this.repository.rmFromVault(imageCoordinates);
                if (result != null) {
                    if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
                        throw new BoxfuseException("Removing " + imageCoordinates + " from Vault failed!");
                    }
                    this.console.ls();
                }
                return;
            }
            AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
            if (appCoordinates != null) {
                Map<String, Object> result = this.repository.rmFromVault(appCoordinates);
                if (result != null) {
                    if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
                        throw new BoxfuseException("Removing all images for " + appCoordinates + " from Vault failed!");
                    }
                    this.console.ls();
                }
                return;
            }
            throw new BoxfuseException("No App or Image specified => use ls to list available ones");
        }
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, true, false, false, true, false);
        Component devHddComponent = this.inventory.retrieveFromLocalInventory(ComponentId.BOXFUSE_DEV_HDD, new Version(BOXFUSE_DEV_HDD_VERSION));
        if (imageCoordinates != null && imageCoordinates.getVersion() != null) {
            LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
            if (platform.isHealthy()) {
                List<Instance> instances = platform.findInstances(imageCoordinates);
                if (!instances.isEmpty()) {
                    LOGGER.info("Killing all Instances of " + imageCoordinates + " on " + platform + " ...");
                    platform.kill(new LaunchSettings(config), instances);
                }
                if ((instances = platform.findInstances(imageCoordinates.getAppCoordinates())).isEmpty() && devHddComponent != null && platform.supportsDevVM()) {
                    platform.getDevVM(devHddComponent, imageCoordinates.getAppCoordinates(), this.getDbType(imageCoordinates.getAppCoordinates(), DbType.NONE)).destroy();
                }
                if (this.shoudStopDevAgent(config, imageCoordinates.getAppCoordinates(), platform)) {
                    this.devAgent.stop();
                }
            }
            if (this.repository.findLocally(imageCoordinates) != null) {
                this.repository.rm(imageCoordinates);
            } else {
                LOGGER.warn("Not removing " + imageCoordinates + " as it doesn't exist");
            }
            return;
        }
        AppCoordinates appCoordinates = imageCoordinates != null ? imageCoordinates.getAppCoordinates() : this.getAppCoordinates(config, true);
        if (appCoordinates == null) {
            throw new BoxfuseException("No App or Image specified => use ls to list available ones");
        }
        LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
        if (platform.isHealthy()) {
            List<Instance> instances = platform.findInstances(appCoordinates);
            if (!instances.isEmpty()) {
                LOGGER.info("Killing all Instances of " + appCoordinates + " on " + platform + " ...");
                platform.kill(new LaunchSettings(config), instances);
            }
            if (devHddComponent != null && platform.supportsDevVM()) {
                platform.getDevVM(devHddComponent, appCoordinates, this.getDbType(appCoordinates, DbType.NONE)).destroy();
            }
            if (this.shoudStopDevAgent(config, appCoordinates, platform)) {
                this.devAgent.stop();
            }
        }
        this.repository.rm(appCoordinates);
    }

    private boolean shoudStopDevAgent(BoxfuseConfig config, AppCoordinates appCoordinates, LocalPlatform<?> platform) {
        return platform.isHealthy() && (platform.needsDevAgent() || LogsType.CLOUDWATCH_LOGS == this.getLogsType(appCoordinates, config)) && platform.runningInstances().isEmpty();
    }

    private ImageSpecImpl createImageSpec(BoxfuseConfig config) {
        ImageSpecImpl imageSpec = new ImageSpecImpl(this.console.getOwner(), config);
        AppCoordinates appCoordinates = imageSpec.getCoordinates().getAppCoordinates();
        if (imageSpec.getAppType() == null) {
            imageSpec.setAppType(this.getAppType(appCoordinates));
        }
        if (imageSpec.getDbType() == null) {
            imageSpec.setDbType(this.getDbType(appCoordinates, null));
        }
        imageSpec.setLogsType(this.getLogsType(appCoordinates, config));
        imageSpec.setTlsType(this.getTlsType(appCoordinates, config));
        return imageSpec;
    }

    public RunResult run(BoxfuseConfig config) {
        this.logConfig(config);
        LaunchSettings launchSettings = new LaunchSettings(config);
        LogsLayout logsLayout = config.logs.layout.get();
        ImageCoordinates imageCoordinates = this.getImageCoordinatesAndFuseIfNecessary(config);
        if (EnvName.DEV == config.env.get()) {
            DbResult dbResult;
            DevVM devVM;
            LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
            platform.ensureHealthy();
            Image image = this.repository.findLocally(imageCoordinates);
            if (image == null) {
                image = this.repository.pull(imageCoordinates);
            }
            if (BoxfuseConfig.VERSION.compareTo(image.getBoxfuseVersion()) < 0) {
                LOGGER.warn("WARNING: " + imageCoordinates + " was fused with a newer version of Boxfuse and may not work correctly with this older one => upgrade your installation to prevent any issues");
            }
            this.validateLaunchSettings(image, launchSettings);
            AppCoordinates appCoordinates = image.getCoordinates().getAppCoordinates();
            Port devAgentPort = null;
            if (platform.needsDevAgent() || LogsType.CLOUDWATCH_LOGS == image.getLogsType()) {
                devAgentPort = this.devAgent.start();
            }
            if (image.getDbType() == DbType.NONE) {
                devVM = null;
                dbResult = null;
            } else {
                devVM = platform.getDevVM(this.getDevHddComponent(), appCoordinates, image.getDbType());
                devVM.createOrStart();
                LOGGER.info("Waiting for database instance to start ...");
                String url = DbType.MYSQL == image.getDbType() ? "jdbc:mysql://localhost:" + devVM.getLocalPort(DbType.MYSQL) + "/boxfuse-dev-db" : "jdbc:postgresql://localhost:" + devVM.getLocalPort(DbType.POSTGRESQL) + "/boxfuse-dev-db?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory";
                String user = "boxfuse-dev-db";
                String password = "boxfuse-dev-db";
                boolean valid = false;
                while (!valid) {
                    try {
                        Connection connection = DriverManager.getConnection(url, user, password);
                        valid = connection.isValid(1000);
                        ThreadUtils.sleep(1000L);
                    }
                    catch (SQLException e) {
                        LOGGER.debug("Database not up yet (" + e.getMessage() + ") => retrying ...");
                        ThreadUtils.sleep(1000L);
                    }
                }
                dbResult = new DbResult(url, user, password);
            }
            int instanceCount = 1;
            LogsFilters logsFilters = config.logs.filter;
            logsFilters.addAppFilter(appCoordinates);
            LaunchResult launchResult = platform.run(this.getAppType(appCoordinates), image, launchSettings, instanceCount, devVM, devAgentPort, logsFilters);
            if (PlatformType.VIRTUALBOX == platform.getType()) {
                this.console.markVirtualBoxOK();
            }
            ArrayList<InstanceResult> instances = new ArrayList<InstanceResult>();
            for (Instance instance : launchResult.getInstances()) {
                instances.add(new InstanceResult(instance.getId().getId(), instance.getPayloadUrl()));
            }
            return new RunResult(new AppResult(((InstanceResult)instances.get(0)).getUrl()), dbResult, new ImageResult(image.getCoordinates().toString()), instances);
        }
        this.pushIfNecessary(config, imageCoordinates);
        Capacity capacity = config.capacity.get();
        Map<String, Object> result = this.console.run(imageCoordinates, launchSettings, capacity, config.securitygroup.getConfigured(), config.instanceprofile.getConfigured(), (Collection<AwsSubnetId>)config.subnets.getConfigured(), config.elasticip.getConfigured(), config.elb.getConfigured(), config.targetgroup.getConfigured(), config.domain.getConfigured(), config.tags);
        if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
            throw new BoxfuseException("Running " + imageCoordinates + " failed!");
        }
        Map<String, Object> ps = this.console.ps(launchSettings.getEnv(), imageCoordinates.getAppCoordinates(), imageCoordinates.getVersion());
        List apps = (List)ps.get("apps");
        AppResult appResult = null;
        DbResult dbResult = null;
        for (Map a : apps) {
            AppInfo appInfo = new AppInfo(a);
            if (!appInfo.getCoordinates().equals(imageCoordinates.getAppCoordinates())) continue;
            appResult = new AppResult(appInfo.getUrl());
            if (DbType.NONE == this.getDbType(appInfo.getCoordinates(), DbType.NONE)) continue;
            String url = "jdbc:postgresql://" + appInfo.getDbHost() + ":" + appInfo.getDbPort().getNumber() + "/" + appInfo.getDbDatabase() + "?ssl=true";
            dbResult = new DbResult(url, appInfo.getDbUser(), appInfo.getDbPassword());
        }
        List instances = (List)ps.get("instances");
        ArrayList<InstanceResult> instancesResult = new ArrayList<InstanceResult>();
        for (Map i2 : instances) {
            String instanceId = (String)i2.get("id");
            if (launchSettings.isLogsTail() && LogsType.CLOUDWATCH_LOGS == this.getLogsType(imageCoordinates.getAppCoordinates(), config)) {
                this.showCloudwatchLogsAwsLogsForInstance(config, launchSettings.isLogsTail(), launchSettings.getEnv(), logsLayout, new InstanceId(instanceId));
            }
            instancesResult.add(new InstanceResult(instanceId, (String)i2.get("url")));
        }
        return new RunResult(appResult, dbResult, new ImageResult(imageCoordinates.toString()), instancesResult);
    }

    private void validateLaunchSettings(ImageSpec spec, LaunchSettings launchSettings) {
        if (launchSettings.getHealthcheckPort() != null) {
            new ImageSpecValidator(spec).validateHealthcheckPort(launchSettings.getHealthcheckPort());
        }
    }

    private Component getDevHddComponent() {
        Component component = this.inventory.get(ComponentId.BOXFUSE_DEV_HDD, new Version(BOXFUSE_DEV_HDD_VERSION));
        File devHdd = new File(component.getFile().getAbsolutePath().replace(".xz", ""));
        if (!devHdd.canRead()) {
            devHdd.delete();
            LOGGER.info("Preparing Boxfuse Dev VM HDD ...");
            ZipUtils.unxz(component.getFile(), devHdd);
        }
        return component;
    }

    private AppType getAppType(AppCoordinates appCoordinates) {
        App app = this.console.getApps().get(appCoordinates);
        return app == null ? AppType.SINGLE_INSTANCE : app.getAppType();
    }

    private DbType getDbType(AppCoordinates appCoordinates, DbType fallback) {
        App app = this.console.getApps().get(appCoordinates);
        return app == null ? fallback : app.getDbType();
    }

    private LogsType getLogsType(AppCoordinates appCoordinates, BoxfuseConfig config) {
        App app = this.console.getApps().get(appCoordinates);
        if (app != null) {
            return app.getLogsType();
        }
        return config.logs.type.get();
    }

    private TlsType getTlsType(AppCoordinates appCoordinates, BoxfuseConfig config) {
        App app = this.console.getApps().get(appCoordinates);
        if (app != null) {
            return app.getTlsType();
        }
        return config.tlsType.get();
    }

    public void scale(BoxfuseConfig config) {
        this.logConfig(config);
        AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
        if (appCoordinates == null) {
            throw new BoxfuseException("You must specify the app to scale");
        }
        if (EnvName.DEV == config.env.get()) {
            throw new BoxfuseException("Scaling is currently only supported on the test and prod environments");
        }
        if (!this.appExists(appCoordinates)) {
            throw new BoxfuseException("Unable to scale unknown app: " + appCoordinates);
        }
        Capacity capacity = config.capacity.get();
        if (capacity == null) {
            throw new BoxfuseException("Missing capacity info => change it to one of the following formats:\n  5:t2.small                        => ensure there are always 5 t2.small instances running\n  2-10:r6i.large:cpu30-70           => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 300 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:cpu30-70:60        => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 60 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:netin1024-8300     => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netin1024-8300:60  => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300    => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300:60 => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above");
        }
        EnvName env = config.env.get();
        Map<String, Object> result = this.console.scale(env, appCoordinates, capacity);
        if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
            throw new BoxfuseException("Scaling " + appCoordinates + " failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Boolean, Map<String, Object>> printMessagesFromLongRunningTask(String task) {
        boolean success;
        Map result = null;
        BusyIndicator busyIndicator = new BusyIndicator();
        try {
            busyIndicator.start();
            Boolean completedSuccess = null;
            long rank = 0L;
            while (completedSuccess == null) {
                Map<String, Object> taskResult = this.console.logsTask(task, rank);
                completedSuccess = (Boolean)taskResult.get("completedSuccess");
                rank = this.printMessages(taskResult, rank);
                if (completedSuccess == null) {
                    ThreadUtils.sleep(1000L);
                    continue;
                }
                result = (Map)taskResult.get("result");
                if (result == null) continue;
                String json = JsonUtils.mapToJson(result);
                if (!this.machineReadable) continue;
                if (completedSuccess.booleanValue()) {
                    MACHINE_READABLE_LOGGER.info(json);
                    continue;
                }
                MACHINE_READABLE_LOGGER.error(json);
            }
            success = completedSuccess;
        }
        finally {
            busyIndicator.stop();
        }
        return Pair.of(success, result);
    }

    private long printMessages(Map<String, Object> result, long rank) {
        List messages = (List)result.get("messages");
        for (Map message : messages) {
            rank = Math.max(rank, (long)((Integer)message.get("rank")).intValue());
            String severity = (String)message.get("severity");
            String text = (String)message.get("message");
            if ("DEBUG".equals(severity)) {
                LOGGER.debug(text);
                continue;
            }
            if ("INFO".equals(severity)) {
                LOGGER.info(text);
                continue;
            }
            if ("WARNING".equals(severity)) {
                LOGGER.warn("WARNING: " + text);
                continue;
            }
            if (!"ERROR".equals(severity)) continue;
            LOGGER.error("ERROR: " + text);
        }
        return rank;
    }

    public void info(BoxfuseConfig config) {
        LOGGER.info(this.infoAsString(config));
    }

    public String infoAsString(BoxfuseConfig config) {
        Map<String, Object> ps;
        List apps;
        AppCoordinates appCoordinates;
        this.logConfig(config);
        if (EnvName.DEV == config.env.get()) {
            DbType dbType;
            AppCoordinates appCoordinates2;
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, true, false, false, true, false);
            String url = null;
            Port dbPort = null;
            if (imageCoordinates == null || this.repository.findLocally(imageCoordinates) == null) {
                appCoordinates2 = this.getAppCoordinates(config, true);
                if (appCoordinates2 == null) {
                    throw new BoxfuseException("You must specify the app get the info for => specify app, image or instance");
                }
                dbType = this.getDbType(appCoordinates2, DbType.NONE);
            } else {
                dbType = this.repository.findLocally((ImageCoordinates)imageCoordinates).getMetadata().database.type;
                appCoordinates2 = imageCoordinates.getAppCoordinates();
                LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
                if (platform.isHealthy()) {
                    List<Instance> instances = platform.findInstances(appCoordinates2);
                    String string = url = instances.isEmpty() ? "" : instances.get(0).getPayloadUrl();
                    if (DbType.NONE != dbType && platform.getDevVM(this.getDevHddComponent(), appCoordinates2, dbType).isRunning()) {
                        DevVM devVM = platform.getDevVM(this.getDevHddComponent(), appCoordinates2, dbType);
                        devVM.createOrStart();
                        dbPort = devVM.getLocalPort(dbType);
                    }
                }
            }
            AppInfo appInfo = new AppInfo(appCoordinates2, url, "available", "localhost", dbPort, "boxfuse-dev-db", "boxfuse-dev-db", "boxfuse-dev-db");
            return new AsciiTableInfo().info(appInfo, EnvName.DEV, this.getAppType(appCoordinates2), dbType, this.getLogsType(appCoordinates2, config));
        }
        EnvName env = config.env.get();
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, true, false, true, false);
        if (imageCoordinates == null) {
            appCoordinates = this.getAppCoordinates(config, true);
            if (appCoordinates == null) {
                throw new BoxfuseException("You must specify the app get the info for => specify app, image or instance");
            }
        } else {
            appCoordinates = imageCoordinates.getAppCoordinates();
        }
        AppInfo appInfo = (apps = (List)(ps = this.console.ps(env, appCoordinates, null)).get("apps")).isEmpty() ? new AppInfo(appCoordinates, null, null, null, null, null, null, null) : new AppInfo((Map)apps.get(0));
        App app = this.console.getApps().get(appCoordinates);
        return new AsciiTableInfo().info(appInfo, env, app.getAppType(), app.getDbType(), app.getLogsType());
    }

    public void open(BoxfuseConfig config) {
        this.logConfig(config);
        boolean isDB = config.db.get();
        if (!isDB && !Desktop.isDesktopSupported()) {
            throw new BoxfuseException("open is not supported on your system as you do not have a desktop => use open from a system where a default browser can be launched");
        }
        if (EnvName.DEV == config.env.get()) {
            if (isDB) {
                ImageCoordinates imageCoordinates = this.getImageCoordinates(config, true, false, true, true, false);
                if (imageCoordinates == null) {
                    throw new BoxfuseException("You must specify the app to open => specify app, image or instance");
                }
                DbType dbType = this.repository.findLocally((ImageCoordinates)imageCoordinates).getMetadata().database.type;
                AppCoordinates appCoordinates = imageCoordinates.getAppCoordinates();
                if (dbType.equals((Object)DbType.NONE)) {
                    throw new BoxfuseException("Unable to open database connection for " + appCoordinates + " in the dev environment as it has no database => select a different app or recreate " + appCoordinates + " with a database");
                }
                LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
                platform.ensureHealthy();
                DevVM devVM = platform.getDevVM(this.getDevHddComponent(), appCoordinates, dbType);
                devVM.createOrStart();
                this.doOpenDb(EnvName.DEV, appCoordinates, dbType, "localhost", devVM.getLocalPort(dbType), "boxfuse-dev-db", "boxfuse-dev-db", "boxfuse-dev-db", false);
                return;
            }
            for (Instance instance : this.getLocalPlatformInstances(config)) {
                InstanceId target = instance.getId();
                String url = instance.getPayloadUrl();
                this.doOpen(EnvName.DEV, target.getId(), url);
            }
            return;
        }
        Set<InstanceId> instances = config.instances.get();
        EnvName env = config.env.get();
        if (instances.isEmpty()) {
            AppCoordinates appCoordinates;
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, true, false, true, false);
            if (imageCoordinates == null) {
                appCoordinates = this.getAppCoordinates(config, true);
                if (appCoordinates == null) {
                    throw new BoxfuseException("You must specify the app to open => specify app, image or instance");
                }
            } else {
                appCoordinates = imageCoordinates.getAppCoordinates();
            }
            if (isDB) {
                DbType dbType = this.getDbType(appCoordinates, DbType.NONE);
                if (dbType.equals((Object)DbType.NONE)) {
                    throw new BoxfuseException("Unable to open database connection for " + appCoordinates + " in the " + env + " environment as it has no database => select a different app or recreate " + appCoordinates + " with a database");
                }
                Map<String, Object> ps = this.console.ps(env, appCoordinates, null);
                List apps = (List)ps.get("apps");
                for (Map app : apps) {
                    AppInfo appInfo = new AppInfo(app);
                    if (!appCoordinates.equals(appInfo.getCoordinates())) continue;
                    String status = appInfo.getDbStatus();
                    if (status == null) {
                        throw new BoxfuseException("Unable to open database connection for " + appCoordinates + " in the " + env + " environment as there is no database => run " + appCoordinates + " in " + env + " to start the database");
                    }
                    if (!"available".equals(status)) {
                        throw new BoxfuseException("Unable to open database connection for " + appCoordinates + " in the " + env + " environment as its state is " + status + " => wait for the database to become available");
                    }
                    this.doOpenDb(env, appCoordinates, dbType, appInfo.getDbHost(), appInfo.getDbPort(), appInfo.getDbDatabase(), appInfo.getDbUser(), appInfo.getDbPassword(), true);
                    return;
                }
                return;
            }
            this.doOpen(env, appCoordinates.toString(), (String)this.console.open(env, appCoordinates).get("url"));
            return;
        }
        InstanceId instanceId = instances.iterator().next();
        this.doOpen(env, instanceId.getId(), (String)this.console.open(env, instanceId).get("url"));
    }

    private void doOpen(EnvName env, String target, String url) {
        if (url == null) {
            throw new BoxfuseBugException(target + " in the " + env + " environment does not support open");
        }
        try {
            LOGGER.info("Launching default browser to access " + target + " in the " + env + " environment at " + url + " ...");
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (UnsupportedOperationException e) {
            throw new BoxfuseException("Your system does not support automatically opening a web browser. Open one manually at " + url + " to see your application in action");
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to launch default browser with url:" + url);
        }
        catch (URISyntaxException e) {
            throw new BoxfuseBugException("Invalid Instance url: " + url);
        }
    }

    private void doOpenDb(EnvName env, AppCoordinates appCoordinates, DbType dbType, String host, Port port, String database, String user, String password, boolean ssl) {
        this.ensureDbExecutableIsAvailable(appCoordinates, dbType);
        File rdsCerts = this.ensureRdsCertIsAvailable();
        LOGGER.info("Launching " + dbType.getExecutable() + " to access the " + appCoordinates + " " + dbType.getDescription() + " in the " + env + " environment ...");
        String encoding = System.getProperty("sun.jnu.encoding", "").toLowerCase();
        String originalEncoding = System.getProperty("sun.stdout.encoding", "").toLowerCase();
        if (dbType == DbType.POSTGRESQL) {
            HashMap<String, String> envVars = new HashMap<String, String>();
            String url = "postgresql://" + user + ":" + password + "@" + host + ":" + port + "/" + database;
            if (ssl) {
                url = url + "?sslmode=verify-full";
                envVars.put("PGSSLROOTCERT", rdsCerts.getAbsolutePath());
            }
            if (OSUtils.runningOnWindows() && encoding.startsWith("cp")) {
                String command = "chcp " + encoding.substring(2) + ">nul & " + dbType.getExecutable() + " \"\"" + url + "\"\"";
                if (originalEncoding.startsWith("cp")) {
                    command = command + " & chcp " + originalEncoding.substring(2) + ">nul";
                }
                ShellUtils.execInteractiveCommand(envVars, "cmd", "/c", "\"" + command + "\"");
            } else {
                ShellUtils.execInteractiveCommand(envVars, dbType.getExecutable(), url);
            }
        } else if (dbType == DbType.MYSQL) {
            ArrayList<String> commands = new ArrayList<String>(Arrays.asList(dbType.getExecutable(), "--host=" + host, "--port=" + port.getNumber(), "--user=" + user, "--password=" + password));
            if (ssl) {
                commands.add("--ssl-ca=" + rdsCerts.getAbsolutePath());
                commands.add("--ssl-verify-server-cert");
            }
            if (OSUtils.runningOnWindows() && encoding.startsWith("cp")) {
                String charset = "utf8mb4";
                if (OSUtils.runningOnWindows()) {
                    switch (encoding) {
                        case "cp850": {
                            charset = "cp850";
                            break;
                        }
                        case "cp852": {
                            charset = "cp852";
                            break;
                        }
                        case "cp866": {
                            charset = "cp866";
                            break;
                        }
                        case "cp932": {
                            charset = "cp932";
                            break;
                        }
                        case "cp1250": {
                            charset = "cp1250";
                            break;
                        }
                        case "cp1251": {
                            charset = "cp1251";
                            break;
                        }
                        case "cp1252": {
                            charset = "latin1";
                            break;
                        }
                        case "cp1256": {
                            charset = "cp1256";
                            break;
                        }
                        case "cp1257": {
                            charset = "cp1257";
                            break;
                        }
                        case "cp65001": {
                            charset = "utf8mb4";
                        }
                    }
                }
                commands.add("--default-character-set=" + charset);
                commands.add(database);
                String command = "chcp " + encoding.substring(2) + ">nul & " + StringUtils.collectionToDelimitedString(commands, " ");
                if (originalEncoding.startsWith("cp")) {
                    command = command + " & chcp " + originalEncoding.substring(2) + ">nul";
                }
                ShellUtils.execInteractiveCommand("cmd", "/c", "\"" + command + "\"");
            } else {
                commands.add(database);
                ShellUtils.execInteractiveCommand(commands.toArray(new String[0]));
            }
        }
    }

    private File ensureRdsCertIsAvailable() {
        File rdsCerts = new File(this.workDir, "rds-combined-ca-bundle.pem");
        if (!rdsCerts.canRead()) {
            IOUtils.copy(IOUtils.copyToByteArray("rds-combined-ca-bundle.pem"), rdsCerts);
        }
        return rdsCerts;
    }

    private void ensureDbExecutableIsAvailable(AppCoordinates appCoordinates, DbType dbType) {
        if (!ShellUtils.executableExists(dbType.getExecutable())) {
            throw new BoxfuseException("Unable to open connection to the " + appCoordinates + " database as \"" + dbType.getExecutable() + (OSUtils.runningOnWindows() ? ".exe" : "") + "\" doesn't exist on the PATH => ensure the latest " + dbType.getDescription() + " client is correctly installed");
        }
    }

    public void logs(BoxfuseConfig config) {
        this.logConfig(config);
        boolean logsBoot = config.logs.boot.get();
        boolean tail = config.logs.tail.get();
        LogsLayout logsLayout = config.logs.layout.get();
        if (EnvName.DEV == config.env.get()) {
            LocalPlatform<?> platform;
            Logs logs;
            boolean cloudwatchLogs;
            List<Instance> instances = this.getLocalPlatformInstances(config);
            if (instances.isEmpty()) {
                LOGGER.info("No logs to show as there are no running instances in the dev environment");
                return;
            }
            Instance instance = instances.get(0);
            AppCoordinates appCoordinates = instance.getImage().getCoordinates().getAppCoordinates();
            boolean bl = cloudwatchLogs = LogsType.CLOUDWATCH_LOGS == this.getLogsType(appCoordinates, config);
            if (logsBoot) {
                LOGGER.debug("Retrieving Boot Logs ...");
                logs = instance.bootLogs();
                LogsUtils.showLogs(logs, instance.getId() + " in dev", !cloudwatchLogs && tail);
            }
            if (cloudwatchLogs) {
                this.devAgent.start();
                LOGGER.debug("Retrieving CloudWatch Logs ...");
                LogsFilters logsFilters = config.logs.filter;
                logsFilters.addAppFilter(appCoordinates);
                logsFilters.addInstanceFilter(instance.getId());
                logs = new CloudwatchLogsMockLogs(this.console.getOwner(), this.devAgent, EnvName.DEV, logsFilters, logsLayout);
                LogsUtils.showLogs(logs, instance.getId() + " in dev", tail);
            }
            if (this.shoudStopDevAgent(config, appCoordinates, platform = this.localPlatformFactory.getLocalPlatform(config))) {
                this.devAgent.stop();
            }
            return;
        }
        Set<InstanceId> instances = config.instances.get();
        EnvName env = config.env.get();
        if (instances.isEmpty()) {
            boolean cloudwatchLogs;
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, EnvName.DEV == config.env.get(), EnvName.DEV != config.env.get(), false, true, false);
            AppCoordinates appCoordinates = imageCoordinates == null ? this.getAppCoordinates(config, true) : imageCoordinates.getAppCoordinates();
            boolean bl = cloudwatchLogs = appCoordinates == null || LogsType.CLOUDWATCH_LOGS == this.getLogsType(appCoordinates, config);
            if (logsBoot && appCoordinates != null) {
                LOGGER.debug("Retrieving Boot Logs ...");
                this.printMessages(this.console.logs(env, appCoordinates), 0L);
            }
            if (cloudwatchLogs) {
                LOGGER.debug("Retrieving CloudWatch Logs ...");
                LogsFilters logsFilters = config.logs.filter;
                logsFilters.addAppFilter(appCoordinates);
                if (imageCoordinates != null) {
                    logsFilters.getFilters().put(LogsFieldName.IMAGE, imageCoordinates);
                }
                CloudwatchLogsAwsLogs logs = new CloudwatchLogsAwsLogs(this.console, env, logsFilters, logsLayout, this.proxy, this.insecure);
                LogsUtils.showLogs(logs, appCoordinates + " in " + env, tail);
            }
            return;
        }
        InstanceId instanceId = instances.iterator().next();
        if (logsBoot) {
            LOGGER.debug("Retrieving Boot Logs ...");
            this.printMessages(this.console.logs(env, instanceId), 0L);
        }
        if (LogsType.CLOUDWATCH_LOGS == config.logs.type.get()) {
            LOGGER.debug("Retrieving CloudWatch Logs ...");
            this.showCloudwatchLogsAwsLogsForInstance(config, tail, env, logsLayout, instanceId);
        }
    }

    private void showCloudwatchLogsAwsLogsForInstance(BoxfuseConfig config, boolean tail, EnvName env, LogsLayout logsLayout, InstanceId instanceId) {
        LogsFilters logsFilters = config.logs.filter;
        logsFilters.addInstanceFilter(instanceId);
        CloudwatchLogsAwsLogs logs = new CloudwatchLogsAwsLogs(this.console, env, logsFilters, logsLayout, this.proxy, this.insecure);
        LogsUtils.showLogs(logs, instanceId + " in " + env, tail);
    }

    private List<Instance> getLocalPlatformInstances(BoxfuseConfig config) {
        LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
        platform.ensureHealthy();
        Set<InstanceId> instanceIds = config.instances.get();
        if (!instanceIds.isEmpty()) {
            return platform.getInstances(instanceIds);
        }
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, true, false, false, true, false);
        if (imageCoordinates != null) {
            List<Instance> instances = platform.findInstances(imageCoordinates);
            if (instances.isEmpty()) {
                throw new BoxfuseException("No running Instances found for " + imageCoordinates + " in the dev environment\n=> ensure env is set to the correct environment\n=> ensure " + imageCoordinates + " is the version currently deployed");
            }
            return instances;
        }
        AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
        if (appCoordinates != null) {
            List<Instance> instances = platform.findInstances(appCoordinates);
            if (instances.isEmpty()) {
                throw new BoxfuseException("No running Instances found for " + appCoordinates + " in the dev environment\n=> ensure env is set to the correct environment");
            }
            return instances;
        }
        return platform.runningInstances();
    }

    public void ps(BoxfuseConfig config) {
        LOGGER.info(this.psAsString(config));
    }

    public String psAsString(BoxfuseConfig config) {
        this.logConfig(config);
        Set<InstanceId> instanceIds = config.instances.get();
        EnvName env = config.env.get();
        if (instanceIds.isEmpty()) {
            Version version;
            AppCoordinates appCoordinates;
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, EnvName.DEV == config.env.get(), EnvName.DEV != config.env.get(), false, false, false);
            if (imageCoordinates == null) {
                appCoordinates = this.getAppCoordinates(config, false);
                version = null;
            } else {
                appCoordinates = imageCoordinates.getAppCoordinates();
                version = imageCoordinates.getVersion();
            }
            if (EnvName.DEV == config.env.get()) {
                LocalPlatform<?> localPlatform = this.localPlatformFactory.getLocalPlatform(config);
                localPlatform.ensureHealthy();
                return new AsciiTableInfo().ps(localPlatform, appCoordinates, version);
            }
            List instances = (List)this.console.ps(env, appCoordinates, version).get("instances");
            return new AsciiTableInfo().psProd(env, instances, appCoordinates, version);
        }
        if (EnvName.DEV == config.env.get()) {
            LocalPlatform<?> localPlatform = this.localPlatformFactory.getLocalPlatform(config);
            localPlatform.ensureHealthy();
            return new AsciiTableInfo().ps(localPlatform, instanceIds);
        }
        InstanceId instanceId = instanceIds.iterator().next();
        List instances = (List)this.console.ps(env, instanceId).get("instances");
        return new AsciiTableInfo().psProd(env, instances, instanceId);
    }

    public void kill(BoxfuseConfig config) {
        this.logConfig(config);
        Set<InstanceId> instanceIds = config.instances.get();
        if (instanceIds.isEmpty()) {
            Version version;
            AppCoordinates appCoordinates;
            ImageCoordinates imageCoordinates = this.getImageCoordinates(config, EnvName.DEV == config.env.get(), EnvName.DEV != config.env.get(), false, false, false);
            if (imageCoordinates == null) {
                appCoordinates = this.getAppCoordinates(config, true);
                version = null;
            } else {
                appCoordinates = imageCoordinates.getAppCoordinates();
                version = imageCoordinates.getVersion();
            }
            if (appCoordinates == null) {
                throw new BoxfuseException("You must specify either the Image or the list of ids of the Instances to kill");
            }
            if (EnvName.DEV == config.env.get()) {
                LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
                if (platform.isHealthy()) {
                    List<Instance> instances = version == null ? platform.findInstances(appCoordinates) : platform.findInstances(new ImageCoordinates(appCoordinates, version));
                    DbType dbType = this.getDbType(appCoordinates, instances.isEmpty() ? DbType.NONE : instances.get(0).getImage().getDbType());
                    platform.kill(new LaunchSettings(config), instances);
                    if (!DbType.NONE.equals((Object)dbType)) {
                        platform.getDevVM(this.getDevHddComponent(), appCoordinates, dbType).stop();
                    }
                    if (this.shoudStopDevAgent(config, appCoordinates, platform)) {
                        this.devAgent.stop();
                    }
                }
            } else {
                if (!this.appExists(appCoordinates)) {
                    throw new BoxfuseException("Unable to kill unknown App: " + appCoordinates);
                }
                Map<String, Object> result = this.console.kill(config.env.get(), appCoordinates, version);
                if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
                    throw new BoxfuseException("Killing " + appCoordinates + " failed!");
                }
            }
            return;
        }
        if (EnvName.DEV == config.env.get()) {
            LocalPlatform<?> platform = this.localPlatformFactory.getLocalPlatform(config);
            if (platform.isHealthy()) {
                List<Instance> instances = platform.getInstances(instanceIds);
                HashSet<AppCoordinates> allAppCoordinates = new HashSet<AppCoordinates>();
                for (Instance instance : instances) {
                    allAppCoordinates.add(instance.getImage().getCoordinates().getAppCoordinates());
                }
                platform.kill(new LaunchSettings(config), instances);
                for (AppCoordinates appCoordinates : allAppCoordinates) {
                    DbType dbType;
                    if (!platform.findInstances(appCoordinates).isEmpty() || DbType.NONE.equals((Object)(dbType = this.getDbType(appCoordinates, DbType.NONE)))) continue;
                    platform.getDevVM(this.getDevHddComponent(), appCoordinates, dbType).stop();
                }
                for (AppCoordinates appCoordinate : allAppCoordinates) {
                    if (!this.shoudStopDevAgent(config, appCoordinate, platform)) continue;
                    this.devAgent.stop();
                }
            }
        } else {
            InstanceId instanceId = instanceIds.iterator().next();
            Map<String, Object> result = this.console.kill(config.env.get(), instanceId);
            if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
                throw new BoxfuseException("Killing " + instanceId + " failed!");
            }
        }
    }

    public void create(BoxfuseConfig config) {
        this.logConfig(config);
        AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
        if (appCoordinates == null) {
            throw new BoxfuseException("You must specify the app to create");
        }
        this.doCreate(appCoordinates, config);
    }

    public void destroy(BoxfuseConfig config) {
        this.logConfig(config);
        AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
        if (appCoordinates == null) {
            throw new BoxfuseException("You must specify the app to destroy");
        }
        if (!this.appExists(appCoordinates)) {
            LOGGER.info("No need to destroy " + appCoordinates + " as it doesn't exist in the Boxfuse Vault");
            return;
        }
        Map<String, Object> result = this.console.destroy(appCoordinates);
        if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
            throw new BoxfuseException("Unable to destroy app " + appCoordinates);
        }
        this.console.ls();
    }

    public void cfg(BoxfuseConfig config) {
        this.logConfig(config);
        AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
        if (appCoordinates == null) {
            throw new BoxfuseException("You must specify the app to configure");
        }
        if (EnvName.DEV == config.env.get()) {
            throw new BoxfuseException("Configuration is currently only supported on the test and prod environments");
        }
        if (!this.appExists(appCoordinates)) {
            throw new BoxfuseException("Unable to configure unknown app: " + appCoordinates);
        }
        Map<String, Object> result = this.console.cfg(config.env.get(), appCoordinates, config.securitygroup.getConfigured(), config.instanceprofile.getConfigured(), (Collection<AwsSubnetId>)config.subnets.getConfigured(), config.elasticip.getConfigured(), config.elb.getConfigured(), config.targetgroup.getConfigured(), config.domain.getConfigured(), config.tags);
        if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
            throw new BoxfuseException("Configuring " + appCoordinates + " failed!");
        }
    }

    private void doCreate(AppCoordinates appCoordinates, BoxfuseConfig config) {
        AppType appType = config.appType.get();
        TlsType tlsType = config.tlsType.get();
        DbType dbType = config.dbType.get();
        LogsType logsType = config.logs.type.get();
        this.doCreate(appCoordinates, appType, tlsType, dbType, logsType);
    }

    private void doCreate(AppCoordinates appCoordinates, AppType appType, TlsType tlsType, DbType dbType, LogsType logsType) {
        boolean exists = this.appExists(appCoordinates);
        if (exists) {
            App app = this.console.getApps().get(appCoordinates);
            if (appType.equals((Object)app.getAppType()) && tlsType.equals((Object)app.getTlsType()) && dbType.equals((Object)app.getDbType()) && logsType.equals((Object)app.getLogsType())) {
                LOGGER.info("Skipping creation of " + appCoordinates + " as it already exists");
                return;
            }
            throw new BoxfuseException("Unable to create " + appCoordinates + " as it already exists with different settings (type: " + app.getAppType().getName() + ", tls: " + app.getTlsType().getName() + ", db: " + app.getDbType().getName() + ", logs: " + app.getLogsType().getName() + ") => destroy and recreate it to change its settings");
        }
        tlsType.ensureSupports(appType);
        if (!this.console.isOnline()) {
            throw new BoxfuseException("Unable to create app " + appCoordinates + " as you are currently offline. Ensure you are online and try again.");
        }
        try {
            Map<String, Object> result = this.console.create(appCoordinates, appType, tlsType, dbType, logsType);
            if (!this.printMessagesFromLongRunningTask((String)result.get("task-id")).getLeft().booleanValue()) {
                throw new BoxfuseException("Creating " + appCoordinates + " failed!");
            }
            this.console.ls();
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to create app " + appCoordinates + ": " + e.getMessage(), e);
        }
    }

    private boolean appExists(ImageCoordinates imageCoordinates) {
        return this.console.getApps().containsKey(imageCoordinates.getAppCoordinates());
    }

    private boolean appExists(AppCoordinates appCoordinates) {
        return this.console.getApps().containsKey(appCoordinates);
    }

    public void push(BoxfuseConfig config) {
        this.logConfig(config);
        ImageCoordinates imageCoordinates = config.image.get();
        if (imageCoordinates == null) {
            AppCoordinates appCoordinates = config.app.get();
            if (appCoordinates == null) {
                throw new BoxfuseException("You must specify the image to push. Possible choices: " + this.getPossibleImagesToPush());
            }
            SortedSet<Image> allLocally = this.repository.findAllLocally(appCoordinates);
            if (allLocally.isEmpty()) {
                throw new BoxfuseException("No local images of " + appCoordinates + " to push => fuse an image and try again");
            }
            imageCoordinates = allLocally.last().getCoordinates();
        }
        if (!this.appExists(imageCoordinates)) {
            this.doCreate(imageCoordinates.getAppCoordinates(), config);
        }
        this.push(imageCoordinates, true);
    }

    private String getPossibleImagesToPush() {
        HashSet<ImageCoordinates> imageCoordinatesSet = new HashSet<ImageCoordinates>();
        for (Image image : this.repository.findAllLocally()) {
            ImageCoordinates coordinates = image.getCoordinates();
            if (this.repository.existsInVault(coordinates)) continue;
            imageCoordinatesSet.add(coordinates);
        }
        return StringUtils.collectionToDelimitedString(imageCoordinatesSet, ", ");
    }

    public ConvertResult convert(BoxfuseConfig config) {
        this.logConfig(config);
        ImageCoordinates imageCoordinates = this.getImageCoordinatesAndFuseIfNecessary(config);
        this.pushIfNecessary(config, imageCoordinates);
        EnvName env = !config.env.isSet() ? EnvName.PROD : config.env.get();
        Map<String, Object> result = this.console.convert(env, imageCoordinates);
        Pair<Boolean, Map<String, Object>> convertResult = this.printMessagesFromLongRunningTask((String)result.get("task-id"));
        if (!convertResult.getLeft().booleanValue()) {
            throw new BoxfuseException("Converting " + imageCoordinates + " failed!");
        }
        Map resultMap = (Map)convertResult.getRight().get("result");
        Map awsMap = (Map)resultMap.get("aws");
        return new ConvertResult(new ImageResult(imageCoordinates.toString()), new AwsResult(awsMap));
    }

    private void pushIfNecessary(BoxfuseConfig config, ImageCoordinates imageCoordinates) {
        if (!this.appExists(imageCoordinates.getAppCoordinates())) {
            config.dbType.set((DbType[])new DbType[]{this.repository.findLocally(imageCoordinates).getDbType()});
            this.doCreate(imageCoordinates.getAppCoordinates(), config);
        }
        this.push(imageCoordinates, false);
    }

    private void push(ImageCoordinates imageCoordinates, boolean showMessageIfAlreadyExistsInVault) {
        if (this.repository.existsInVault(imageCoordinates)) {
            if (showMessageIfAlreadyExistsInVault) {
                LOGGER.info(imageCoordinates + " already exists in the Boxfuse Vault. No need to push.");
            }
            return;
        }
        if (!this.repository.existsLocally(imageCoordinates)) {
            String possibleImagesToPush = this.getPossibleImagesToPush();
            throw new BoxfuseException("Unable to push unknown image (" + imageCoordinates + ") => " + (StringUtils.hasLength(possibleImagesToPush) ? "Possible choices: " + possibleImagesToPush : "Fuse the image first and try again"));
        }
        this.repository.push(imageCoordinates);
        this.console.ls();
    }

    private ImageCoordinates getImageCoordinatesAndFuseIfNecessary(BoxfuseConfig config) {
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, false, false, false, false);
        if (imageCoordinates == null || !this.repository.exists(imageCoordinates)) {
            ImageSpecImpl imageSpec = this.createImageSpec(config);
            int fingerprint = this.getFingerprint(imageSpec);
            Image image = this.repository.findLocally(fingerprint);
            if (image == null) {
                imageCoordinates = this.repository.findInVault(fingerprint);
                if (imageCoordinates == null) {
                    imageCoordinates = this.fuse(imageSpec, config).getCoordinates();
                }
            } else {
                imageCoordinates = image.getCoordinates();
            }
        }
        return imageCoordinates;
    }

    public void pull(BoxfuseConfig config) {
        this.logConfig(config);
        ImageCoordinates imageCoordinates = this.getImageCoordinates(config, false, false, false, true, true);
        if (imageCoordinates == null) {
            AppCoordinates appCoordinates = this.getAppCoordinates(config, true);
            if (appCoordinates != null) {
                imageCoordinates = this.repository.completeImageCoordinates(appCoordinates.toString(), false, false, true, true);
            } else {
                throw new BoxfuseException("You must specify the image to pull");
            }
        }
        this.repository.pull(imageCoordinates);
    }

    public void reportClientError(boolean bug, BoxfuseConfig config, Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        this.console.error(bug, new String[]{}, config == null ? new HashMap() : config.toMap(), stackTrace);
    }

    public boolean validImageCoordinates(String coordinates) {
        return ImageCoordinates.validate(coordinates, this.console.getOwner());
    }

    public boolean validAppCoordinates(String coordinates) {
        return AppCoordinates.validate(coordinates, this.console.getOwner());
    }

    public Pair<String, String> getCommandLineUpgradeInfo() {
        return Pair.of(this.console.getUpdateVersion(), this.console.getUpdateUrlCommandLine());
    }

    private AppCoordinates getAppCoordinates(BoxfuseConfig config, boolean fallback) {
        ImageSpecImpl imageSpec;
        if (config.app.isSet()) {
            return config.app.get();
        }
        if (config.image.isSet()) {
            return config.image.get().getAppCoordinates();
        }
        if (!fallback) {
            return null;
        }
        try {
            imageSpec = this.createImageSpec(config);
        }
        catch (Exception e) {
            return null;
        }
        return imageSpec.getCoordinates().getAppCoordinates();
    }

    private ImageCoordinates getImageCoordinates(BoxfuseConfig config, boolean localOnly, boolean vaultOnly, boolean fail, boolean fallback, boolean defaultToLatest) {
        ImageCoordinates imageCoordinates;
        Image image;
        ImageSpecImpl imageSpec;
        if (config.image.isSet()) {
            ImageCoordinates imageCoordinates2 = config.image.get();
            if (imageCoordinates2.getVersion() != null) {
                return imageCoordinates2;
            }
            return this.repository.completeImageCoordinates(config.image.get().getCoordinates(), localOnly, vaultOnly, fail, defaultToLatest);
        }
        if (config.app.isSet()) {
            return this.repository.completeImageCoordinates(config.app.get().getCoordinates(), localOnly, vaultOnly, fail, !config.payload.location.isSet());
        }
        if (!fallback) {
            if (fail) {
                throw new BoxfuseException("No image or app specified => ensure image or app is set");
            }
            return null;
        }
        try {
            imageSpec = this.createImageSpec(config);
        }
        catch (Exception e) {
            if (fail) {
                throw new BoxfuseException("No image or app specified => ensure image or app is set", e);
            }
            return null;
        }
        if (imageSpec.getCoordinates().getVersion() != null) {
            return this.repository.completeImageCoordinates(imageSpec.getCoordinates().toString(), localOnly, vaultOnly, fail, defaultToLatest);
        }
        int fingerprint = this.getFingerprint(imageSpec);
        if (!vaultOnly && (image = this.repository.findLocally(fingerprint)) != null) {
            return image.getCoordinates();
        }
        if (!localOnly && (imageCoordinates = this.repository.findInVault(fingerprint)) != null) {
            return imageCoordinates;
        }
        if (imageSpec.getCoordinates() != null) {
            return this.repository.completeImageCoordinates(imageSpec.getCoordinates().toString(), localOnly, vaultOnly, fail, defaultToLatest);
        }
        if (fail) {
            throw new BoxfuseException("No image or app specified => ensure image or app is set");
        }
        return null;
    }

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        Locale.setDefault(Locale.ENGLISH);
    }
}

