/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.cloudwatchlogs;

import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.LogsListener;
import com.boxfuse.base.logs.cloudwatchlogs.CloudwatchLogsLogs;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.util.HttpUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.ThreadUtils;
import com.boxfuse.generator.config.LogsFilters;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudwatchLogsHttpLogs
extends CloudwatchLogsLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudwatchLogsHttpLogs.class);
    private final Proxy proxy;
    private final boolean insecure;
    private CloseableHttpClient httpClient;

    CloudwatchLogsHttpLogs(Owner owner, EnvName env, LogsFilters filters, LogsLayout layout, Proxy proxy, boolean insecure) {
        super(owner, env, filters.getFilters(), layout);
        this.proxy = proxy;
        this.insecure = insecure;
    }

    @Override
    protected void init(boolean tail, LogsListener logsListener) {
        this.httpClient = HttpUtils.createHttpClient(this.proxy, true, this.insecure);
        super.init(tail, logsListener);
    }

    @Override
    protected Map<String, Object> filterLogEvents(Long startTime, Long endTime, Long limit, String nextToken) throws IOException {
        Map<String, Object> map;
        String logGroupName = "boxfuse/" + this.env;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logGroupName", logGroupName);
        if (startTime != null) {
            data.put("startTime", startTime);
        }
        if (endTime != null) {
            data.put("endTime", endTime);
        }
        if (limit != null) {
            data.put("limit", limit);
        }
        if (nextToken != null) {
            data.put("nextToken", nextToken);
        }
        if (this.filterPattern != null) {
            data.put("filterPattern", this.filterPattern);
        }
        data.put("interleaved", true);
        int retries = 0;
        while (true) {
            String json;
            int retrySeconds = 1 << retries;
            ++retries;
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.createRequest(data));){
                json = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Exception e) {
                if (retries > 6) {
                    throw e;
                }
                LOGGER.debug("Unable to connect to AWS CloudWatch Logs (" + e.getMessage() + ") => retrying in " + retrySeconds + " sec ...");
                ThreadUtils.sleep(1000 * retrySeconds);
                continue;
            }
            try {
                map = JsonUtils.jsonToMap(json);
            }
            catch (Exception e) {
                String message = "Unable to retrieve logs (" + e.getMessage() + "): " + json;
                if (retries > 10) {
                    throw new BoxfuseException(message);
                }
                LOGGER.warn(message + " => retrying in " + retrySeconds + " sec ...");
                ThreadUtils.sleep(1000 * retrySeconds);
                continue;
            }
            if (map.containsKey("events")) break;
            boolean throttling = "ThrottlingException".equals(map.get("__type"));
            boolean accessDenied = "AccessDeniedException".equals(map.get("__type"));
            boolean notFound = "ResourceNotFoundException".equals(map.get("__type"));
            String details = throttling ? "AWS request rate exceeded" : (accessDenied || notFound ? (String)map.get("Message") : json);
            String message = "Unable to retrieve logs from Log Group " + logGroupName + " : " + details;
            if (retries > 10) {
                throw new BoxfuseException(message);
            }
            LOGGER.warn(message + " => retrying in " + retrySeconds + " sec ...");
            ThreadUtils.sleep(1000 * retrySeconds);
        }
        return map;
    }

    protected abstract HttpPost createRequest(Map<String, Object> var1);

    @Override
    public void stop() {
        super.stop();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                CloudwatchLogsHttpLogs.this.waitForStop();
                IOUtils.close((Closeable)CloudwatchLogsHttpLogs.this.httpClient);
            }
        });
        thread2.setDaemon(true);
        thread2.start();
    }
}

