/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.console;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.port.Port;
import java.util.Map;

public class AppInfo {
    private final AppCoordinates coordinates;
    private final String url;
    private final String dbStatus;
    private final String dbHost;
    private final Port dbPort;
    private final String dbDatabase;
    private final String dbUser;
    private final String dbPassword;

    public AppInfo(AppCoordinates coordinates, String url, String dbStatus, String dbHost, Port dbPort, String dbDatabase, String dbUser, String dbPassword) {
        this.coordinates = coordinates;
        this.url = url;
        this.dbStatus = dbStatus;
        this.dbHost = dbHost;
        this.dbPort = dbPort;
        this.dbDatabase = dbDatabase;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
    }

    public AppInfo(Map<String, Object> info) {
        this.coordinates = new AppCoordinates(info.get("coordinates").toString(), null);
        this.url = (String)info.get("url");
        Map db = (Map)info.get("db");
        if (db == null) {
            this.dbStatus = null;
            this.dbHost = null;
            this.dbPort = null;
            this.dbDatabase = null;
            this.dbUser = null;
            this.dbPassword = null;
            return;
        }
        this.dbStatus = (String)db.get("status");
        this.dbHost = (String)db.get("host");
        this.dbPort = db.get("port") == null ? null : Port.getUnrestrictedTcpPort((Integer)db.get("port"));
        this.dbDatabase = (String)db.get("database");
        this.dbUser = (String)db.get("user");
        this.dbPassword = (String)db.get("password");
    }

    public AppCoordinates getCoordinates() {
        return this.coordinates;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDbStatus() {
        return this.dbStatus;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public Port getDbPort() {
        return this.dbPort;
    }

    public String getDbDatabase() {
        return this.dbDatabase;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }
}

