/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.console;

import com.boxfuse.base.aws.AwsELBName;
import com.boxfuse.base.aws.AwsInstanceProfileArn;
import com.boxfuse.base.aws.AwsSecurityGroupId;
import com.boxfuse.base.aws.AwsSubnetId;
import com.boxfuse.base.aws.AwsTagKey;
import com.boxfuse.base.aws.AwsTagValue;
import com.boxfuse.base.aws.AwsTargetGroupName;
import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.crypto.CryptoUtils;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.Capacity;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Domain;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.ServerUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ThreadUtils;
import com.boxfuse.client.core.internal.cache.ActivationCache;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.generator.app.App;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.inventory.RemoteInventory;
import com.boxfuse.generator.repository.Vault;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.client.HttpResponseException;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements RemoteInventory,
Vault,
CertificateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Console.class);
    private static final String CLIENT_API_VERSION = "v1";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private final ActivationCache cache;
    private final boolean online;
    private final Proxy proxy;
    private final boolean insecure;
    private final String url;
    private final String userAgent;
    private final String macHash;
    private final String sessionId;
    private Owner owner;
    private String name;
    private String privateKey;
    private boolean virtualBoxOK;
    private final Map<ComponentId, SortedSet<Version>> components = new TreeMap<ComponentId, SortedSet<Version>>();
    private final List<Map<String, String>> messages = new ArrayList<Map<String, String>>();
    private final String updateVersion;
    private final String updateUrlCommandLine;
    private Map<AppCoordinates, App> apps;

    public Owner getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    public List<Map<String, String>> getMessages() {
        return this.messages;
    }

    public String getUpdateUrlCommandLine() {
        return this.updateUrlCommandLine;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public Map<ComponentId, SortedSet<Version>> listAllComponents() {
        return this.components;
    }

    @Override
    public Map<AppCoordinates, App> getApps() {
        return this.apps;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Console(ActivationCache cache, String user, String secret, String userAgent, boolean offline, Proxy proxy, boolean insecure) {
        String urlHex;
        Console.validateUserAndSecret(user, secret);
        String console = System.getProperty("boxfuse.console");
        if ("mocks".equals(console)) {
            urlHex = "68747470733a2f2f636f6e736f6c652d6465762e626f78667573652d746573742e64653a3138333333";
            this.insecure = true;
        } else if ("dev".equals(console)) {
            urlHex = "68747470733a2f2f636f6e736f6c652d6465762e626f78667573652d746573742e64653a3138343433";
            this.insecure = true;
        } else if ("test".equals(console)) {
            urlHex = "68747470733a2f2f636f6e736f6c65322e626f78667573652d746573742e6465";
            this.insecure = insecure;
        } else {
            urlHex = "68747470733a2f2f636f6e736f6c652e636c6f75646361707461696e2e7368";
            this.insecure = insecure;
        }
        this.url = new String(ByteArrayUtils.fromHex(urlHex), StandardCharsets.UTF_8) + "/client/" + CLIENT_API_VERSION + "/";
        this.cache = cache;
        this.proxy = proxy;
        this.userAgent = userAgent;
        this.macHash = ByteArrayUtils.toHex(CryptoUtils.sha256Digest(ServerUtils.getMacAddress().getBytes()));
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("user", user);
        request.put("secret", secret);
        request.put("macHash", this.macHash);
        Map<String, Object> result = null;
        if (!offline) {
            int retries = 0;
            while (retries++ <= 5) {
                block31: {
                    result = null;
                    try {
                        result = this.executePost("session", request, this.createUserAgentHeader());
                        if (!((Boolean)result.get(SUCCESS)).booleanValue()) {
                        }
                        break block31;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Session creation failed. Retrying...", (Throwable)e);
                        ThreadUtils.sleep(1000L);
                    }
                    continue;
                }
                if (cache.hasActivation()) {
                    this.loadCache();
                }
                this.online = true;
                this.sessionId = (String)result.get("sessionId");
                this.owner = new Owner((String)result.get("owner"));
                this.name = (String)result.get("name");
                this.privateKey = (String)result.get("privateKey");
                this.setComponents((Map)result.get("components"));
                this.setApps((Map)result.get("apps"));
                Map update = (Map)result.get("update");
                if (update == null) {
                    this.updateVersion = null;
                    this.updateUrlCommandLine = null;
                } else {
                    this.updateVersion = (String)update.get("version");
                    this.updateUrlCommandLine = (String)update.get("urlCommandLine");
                }
                List messages = (List)result.get("messages");
                if (messages != null) {
                    block15: for (Map message : messages) {
                        String severity = (String)message.get("severity");
                        String text = (String)message.get("message");
                        switch (severity) {
                            case "ERROR": {
                                LOGGER.error(text);
                                continue block15;
                            }
                            case "WARNING": {
                                LOGGER.warn(text);
                                continue block15;
                            }
                            case "DEBUG": {
                                LOGGER.debug(text);
                                continue block15;
                            }
                        }
                        LOGGER.info(text);
                    }
                }
                this.saveCache();
                return;
            }
        }
        if (result == null) {
            if (!cache.hasActivation()) {
                throw new BoxfuseException("You must be online once before you can use Boxfuse offline. Go online and try again");
            }
            try {
                this.online = false;
                this.sessionId = null;
                this.updateVersion = null;
                this.updateUrlCommandLine = null;
                this.loadCache();
                if (!offline) {
                    LOGGER.info("Unable to connect to your Boxfuse account. Enabling offline mode.");
                }
                return;
            }
            catch (Exception e) {
                throw new BoxfuseException("You must be online once before you can use Boxfuse offline. Go online and try again");
            }
        }
        throw new BoxfuseException((String)result.get(ERROR));
    }

    private void loadCache() {
        try {
            Map<String, Object> activation = this.cache.loadActivation();
            this.owner = new Owner((String)activation.get("owner"));
            this.name = (String)activation.get("name");
            this.privateKey = (String)activation.get("privateKey");
            this.virtualBoxOK = Boolean.TRUE.equals(activation.get("virtualBoxOK"));
            this.setApps((Map)activation.get("apps"));
        }
        catch (Exception e) {
            LOGGER.debug("Unable to read cached account data for offline use: " + e.getClass().getName() + " -> " + e.getMessage());
        }
    }

    private void saveCache() {
        try {
            HashMap<String, Object> activation = new HashMap<String, Object>();
            activation.put("owner", this.owner.getOwner());
            activation.put("name", this.name);
            activation.put("privateKey", this.privateKey);
            activation.put("virtualBoxOK", this.virtualBoxOK);
            activation.put("apps", this.apps);
            this.cache.saveActivation(activation);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to cache account data for offline use: " + e.getMessage());
        }
    }

    public void markVirtualBoxOK() {
        if (!this.virtualBoxOK) {
            this.virtualBoxOK = true;
            this.saveCache();
        }
    }

    public boolean isVirtualBoxOK() {
        return this.virtualBoxOK;
    }

    private Map<String, Object> post(String path, Map<String, Object> data) {
        Map<String, Object> result = null;
        int retries = 0;
        String error = null;
        while (retries++ < 5 && result == null) {
            try {
                result = this.executePost(path, data, this.createSessionIdHeader(), this.createMacHashHeader(), this.createUserAgentHeader());
            }
            catch (HttpResponseException e) {
                error = "Console communication error: " + e.getStatusCode() + " (" + e.getMessage() + ")";
                if (retries == 5) break;
                LOGGER.debug(error + " => retrying in " + retries + "s ...");
                ThreadUtils.sleep(1000 * retries);
            }
            catch (IOException e) {
                error = "Console communication error: " + e.getMessage();
                if (retries == 5) break;
                LOGGER.debug(error + " => retrying in " + retries + "s ...");
                ThreadUtils.sleep(1000 * retries);
            }
        }
        if (result == null) {
            throw new BoxfuseException(error);
        }
        if (!((Boolean)result.get(SUCCESS)).booleanValue()) {
            throw new BoxfuseException((String)result.get(ERROR));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> executePost(String path, Map<String, Object> data, Header ... headers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void validateUserAndSecret(String user, String secret) {
        if (!StringUtils.hasLength(user)) {
            throw new BoxfuseException("Missing Boxfuse user. Check your configuration.\n=> you can obtain your credentials from the Downloads tab in the Boxfuse Console");
        }
        if (!StringUtils.hasLength(secret)) {
            throw new BoxfuseException("Missing Boxfuse secret. Check your configuration.\n=> you can obtain your credentials from the Downloads tab in the Boxfuse Console");
        }
        if (!user.matches("[a-f0-9]{32}")) {
            throw new BoxfuseException("Invalid Boxfuse user. Check your configuration\n=> you can obtain your credentials from the Downloads tab in the Boxfuse Console");
        }
        if (!secret.matches("[0-9A-Za-z]{64}")) {
            throw new BoxfuseException("Invalid Boxfuse secret. Check your configuration.\n=> you can obtain your credentials from the Downloads tab in the Boxfuse Console");
        }
    }

    private void setComponents(Map<String, Object> inventoryComponents) {
        this.components.clear();
        for (Map.Entry<String, Object> entry : inventoryComponents.entrySet()) {
            TreeSet<Version> versions = new TreeSet<Version>();
            List versionStrs = (List)entry.getValue();
            for (String str : versionStrs) {
                versions.add(new Version(str, true));
            }
            ComponentId componentId = ComponentId.of(entry.getKey(), false);
            if (componentId == null) continue;
            if (componentId.getDefaultVersion() != null) {
                versions.add(componentId.getDefaultVersion());
            }
            this.components.put(componentId, versions);
        }
    }

    private void setApps(Map<String, Object> remoteApps) {
        this.apps = new TreeMap<AppCoordinates, App>();
        if (remoteApps == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : remoteApps.entrySet()) {
            TlsType tlsType;
            LogsType logsType;
            DbType dbType;
            AppType appType;
            AppCoordinates appCoordinates = new AppCoordinates(entry.getKey(), this.owner);
            Map details = (Map)entry.getValue();
            String apptype = (String)details.get("apptype");
            try {
                appType = AppType.of(apptype);
            }
            catch (Exception e) {
                LOGGER.warn("Unknown app type for " + appCoordinates + " (" + apptype + ") => upgrade your client to be able to work with this app");
                continue;
            }
            String dbtype = (String)details.get("dbtype");
            try {
                dbType = DbType.fromName(dbtype);
            }
            catch (Exception e) {
                LOGGER.warn("Unknown DB type for " + appCoordinates + " (" + dbtype + ") => upgrade your client to be able to work with this app");
                continue;
            }
            String logstype = (String)details.get("logstype");
            try {
                logsType = LogsType.fromName(logstype);
            }
            catch (Exception e) {
                LOGGER.warn("Unknown Logs type for " + appCoordinates + " (" + logstype + ") => upgrade your client to be able to work with this app");
                continue;
            }
            String tlstype = (String)details.get("tlstype");
            try {
                tlsType = TlsType.fromName(tlstype);
            }
            catch (Exception e) {
                LOGGER.warn("Unknown Tls type for " + appCoordinates + " (" + tlstype + ") => upgrade your client to be able to work with this app");
                continue;
            }
            List imageDetails = (List)details.get("images");
            TreeMap<Version, Integer> images = new TreeMap<Version, Integer>();
            if (imageDetails != null) {
                for (Map imageDetail : imageDetails) {
                    images.put(new Version((String)imageDetail.get("version")), (Integer)imageDetail.get("fingerprint"));
                }
            }
            this.apps.put(appCoordinates, new App(appCoordinates, appType, dbType, logsType, tlsType, images));
        }
    }

    private Header createSessionIdHeader() {
        return new BasicHeader("SessionId", this.sessionId);
    }

    private Header createMacHashHeader() {
        return new BasicHeader("MacHash", this.macHash);
    }

    private Header createUserAgentHeader() {
        return new BasicHeader("User-Agent", this.userAgent);
    }

    @Override
    public String generateDownloadUrl(ComponentId id, Version version) {
        String directFetchUrl = id.getDirectFetchUrl(version);
        if (directFetchUrl != null) {
            return directFetchUrl;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id.getId());
        params.put("version", version.getVersion());
        params.put("extension", id.getFormat());
        return (String)this.post("inventory/download", params).get("url");
    }

    public void error(boolean bug, String[] args2, Map<String, String> config, String stackTrace) {
        if (this.online) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bug", bug);
            params.put("args", args2);
            params.put("config", config);
            params.put("stacktrace", stackTrace);
            this.post(ERROR, params);
        }
    }

    public Map<String, Object> create(AppCoordinates appCoordinates, AppType appType, TlsType tlsType, DbType dbType, LogsType logsType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.setAppCoordinates(params, appCoordinates);
        params.put("type", appType.getName());
        params.put("tlstype", tlsType.getName());
        params.put("dbtype", dbType.getName());
        params.put("logstype", logsType.getName());
        return this.post("create", params);
    }

    public Map<String, Object> destroy(AppCoordinates appCoordinates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.setAppCoordinates(params, appCoordinates);
        return this.post("destroy", params);
    }

    @Override
    public Map<String, Object> push(String id, ImageCoordinates imageCoordinates, String signature, long size, String fusedUtc, Map<String, Object> manifest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.setImageCoordinates(params, imageCoordinates);
        params.put("signature", signature);
        params.put("size", size);
        params.put("fusedUtc", fusedUtc);
        params.put("manifest", manifest);
        params.put("parts", true);
        return this.post("vault/push", params);
    }

    private void setImageCoordinates(Map<String, Object> params, ImageCoordinates imageCoordinates) {
        this.setAppCoordinates(params, imageCoordinates.getAppCoordinates());
        params.put("version", imageCoordinates.getVersion().getVersion());
    }

    @Override
    public Map<String, Object> pushParts(String id, ImageCoordinates imageCoordinates, long size, List<Map<String, Object>> partsInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.setImageCoordinates(params, imageCoordinates);
        params.put("size", size);
        params.put("parts", partsInfo);
        return this.post("vault/pushParts", params);
    }

    @Override
    public void verify(String id, List<String> partETags) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        if (partETags != null) {
            params.put("partETags", partETags);
        }
        Map<String, Object> result = this.post("vault/verify", params);
        this.setApps((Map)result.get("apps"));
    }

    public Map<String, Object> run(ImageCoordinates imageCoordinates, LaunchSettings launchSettings, Capacity capacity, AwsSecurityGroupId securitygroup, AwsInstanceProfileArn instanceprofile, Collection<AwsSubnetId> subnets, IpAddress elasticIp, AwsELBName elb, AwsTargetGroupName targetGroup, Domain domain, Map<AwsTagKey, AwsTagValue> tags) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.setImageCoordinates(params, imageCoordinates);
        params.put("env", launchSettings.getEnv());
        params.put("ports", this.convertPorts(launchSettings.getPorts()));
        params.put("envvars", this.convertEnvVars(launchSettings.getEnvVars()));
        params.put("logsAuto", launchSettings.isLogsAuto());
        params.put("logsBoot", launchSettings.isLogsBoot());
        params.put("debug", launchSettings.getDebug());
        params.put("debugWait", launchSettings.getDebugWait());
        params.put("healthcheck", launchSettings.getHealthcheck());
        params.put("healthcheckPath", launchSettings.getHealthcheckPath());
        if (launchSettings.getHealthcheckPort() != null) {
            params.put("healthcheckPort", launchSettings.getHealthcheckPort().getName());
        }
        params.put("healthcheckTimeout", launchSettings.getHealthcheckTimeout());
        params.put("tmp", launchSettings.getTmp());
        params.put("jvmArgs", launchSettings.getJvmArgs());
        params.put("jvmMainClass", launchSettings.getJvmMainClass());
        params.put("jvmMainArgs", launchSettings.getJvmMainArgs());
        params.put("jvmJmx", launchSettings.getJvmJmx());
        if (capacity != null) {
            this.setCapacity(params, capacity);
        }
        this.setCfg(params, securitygroup, instanceprofile, subnets, elasticIp, elb, targetGroup, domain, tags);
        return this.post("run", params);
    }

    private Map<String, String> convertEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<EnvVarName, EnvVarValue> entry : envVars.entrySet()) {
            result.put(entry.getKey().getName(), entry.getValue().getValue());
        }
        return result;
    }

    private Map<String, Object> convertPorts(Map<PortName, Port> ports) {
        if (ports.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<PortName, Port> port : ports.entrySet()) {
            result.put(port.getKey().getName(), port.getValue().toString());
        }
        return result;
    }

    private void setCapacity(Map<String, Object> params, Capacity capacity) {
        params.put("instanceMin", capacity.getInstanceMin());
        params.put("instanceMax", capacity.getInstanceMax());
        params.put("instanceType", capacity.getInstanceType().getName());
        params.put("scalingType", capacity.getScalingType().name());
        params.put("scalingAlarmDown", capacity.getScalingAlarmDown());
        params.put("scalingAlarmUp", capacity.getScalingAlarmUp());
        params.put("scalingAlarmDuration", capacity.getScalingAlarmDuration());
    }

    public Map<String, Object> scale(EnvName env, AppCoordinates appCoordinates, Capacity capacity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        this.setCapacity(params, capacity);
        return this.post("scale", params);
    }

    public Map<String, Object> cfg(EnvName env, AppCoordinates appCoordinates, AwsSecurityGroupId securitygroup, AwsInstanceProfileArn instanceprofile, Collection<AwsSubnetId> subnets, IpAddress elasticIp, AwsELBName elb, AwsTargetGroupName targetGroup, Domain domain, Map<AwsTagKey, AwsTagValue> tags) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        this.setCfg(params, securitygroup, instanceprofile, subnets, elasticIp, elb, targetGroup, domain, tags);
        return this.post("cfg", params);
    }

    private void setCfg(Map<String, Object> params, AwsSecurityGroupId securitygroup, AwsInstanceProfileArn instanceprofile, Collection<AwsSubnetId> subnets, IpAddress elasticIp, AwsELBName elb, AwsTargetGroupName targetGroup, Domain domain, Map<AwsTagKey, AwsTagValue> tags) {
        params.put("securitygroup", securitygroup);
        params.put("instanceprofile", instanceprofile);
        params.put("subnets", subnets);
        params.put("elasticip", elasticIp);
        params.put("elb", elb);
        params.put("targetgroup", targetGroup);
        params.put("domain", domain);
        params.put("tags", tags);
    }

    private void setAppCoordinates(Map<String, Object> params, AppCoordinates appCoordinates) {
        if (appCoordinates == null) {
            return;
        }
        params.put("owner", appCoordinates.getOwner().getOwner());
        params.put("name", appCoordinates.getName().getName());
    }

    public Map<String, Object> ps(EnvName env, AppCoordinates appCoordinates, Version version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        if (appCoordinates != null) {
            this.setAppCoordinates(params, appCoordinates);
            if (version != null) {
                params.put("version", version.getVersion());
            }
        }
        return this.post("ps", params);
    }

    public Map<String, Object> ps(EnvName env, InstanceId instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        params.put("instance", instanceId.getId());
        return this.post("ps", params);
    }

    public Map<String, Object> kill(EnvName env, AppCoordinates appCoordinates, Version version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        if (version != null) {
            params.put("version", version.getVersion());
        }
        return this.post("kill", params);
    }

    public Map<String, Object> kill(EnvName env, InstanceId instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        params.put("instance", instanceId.getId());
        return this.post("kill", params);
    }

    public Map<String, Object> logsTask(String task, Long rank) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("task-id", task);
        params.put("rank", rank);
        return this.post("logs", params);
    }

    @Override
    public Map<String, Object> pull(ImageCoordinates imageCoordinates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.setImageCoordinates(params, imageCoordinates);
        return this.post("vault/pull", params);
    }

    public Map<String, Object> convert(EnvName env, ImageCoordinates imageCoordinates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setImageCoordinates(params, imageCoordinates);
        return this.post("convert", params);
    }

    @Override
    public Map<String, Object> rm(AppCoordinates appCoordinates, Version version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.setAppCoordinates(params, appCoordinates);
        if (version != null) {
            params.put("version", version.getVersion());
        }
        return this.post("vault/rm", params);
    }

    public void ls() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> result = this.post("vault/ls", params);
        this.setApps((Map)result.get("apps"));
    }

    public Map<String, Object> open(EnvName env, AppCoordinates appCoordinates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        return this.post("open", params);
    }

    public Map<String, Object> open(EnvName env, InstanceId instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        params.put("instance", instanceId.getId());
        return this.post("open", params);
    }

    public Map<String, Object> logs(EnvName env, AppCoordinates appCoordinates) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        return this.post("logs", params);
    }

    public Map<String, Object> logs(EnvName env, InstanceId instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        params.put("instance", instanceId.getId());
        return this.post("logs", params);
    }

    public Map<String, Object> cloudwatchlogs(EnvName env, AppCoordinates appCoordinates, Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("env", env);
        this.setAppCoordinates(params, appCoordinates);
        params.putAll(data);
        return this.post("logs/cloudwatchlogs", params);
    }

    @Override
    public byte[] getPkcs12ForApp(AppCoordinates appCoordinates) {
        return new byte[0];
    }
}

