/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.diskimage;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.UuidUtils;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.generator.image.Image;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class Vhd
extends DiskImage {
    private static final long EPOCH_START = DateUtils.toUtcDateTimeMillis("2000-01-01 00:00:00.000").getTime();
    private static final int BYTES_PER_SECTOR = 512;

    public Vhd(Image image, File directory) {
        super(image, directory);
    }

    @Override
    public void save() {
        long cylinderTimesHeads;
        long heads;
        long sectorsPerTrack;
        File diskImageFile = this.getMainFile();
        try {
            IOUtils.copy(this.image.getDiskImage(), diskImageFile);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to extract disk image for " + this.image.getCoordinates() + " (" + e.getMessage() + ")", e);
        }
        ByteBuffer footer = ByteBuffer.allocate(512);
        footer.put("conectix".getBytes(StandardCharsets.US_ASCII));
        footer.put(new byte[4]);
        footer.putShort((short)1);
        footer.putShort((short)0);
        footer.put(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        int diff = (int)(System.currentTimeMillis() - EPOCH_START);
        footer.put(ByteArrayUtils.fromInt(diff));
        footer.put("boxf".getBytes(StandardCharsets.US_ASCII));
        footer.putShort((short)1);
        footer.putShort((short)0);
        footer.put(new byte[]{87, 105, 50, 107});
        long diskSizeInBytes = this.image.getMetadata().size;
        footer.putLong(diskSizeInBytes);
        footer.putLong(diskSizeInBytes);
        long totalSectors = diskSizeInBytes / 512L;
        if (totalSectors > 267382800L) {
            totalSectors = 267382800L;
        }
        if (totalSectors >= 66059280L) {
            sectorsPerTrack = 255L;
            heads = 16L;
            cylinderTimesHeads = totalSectors / sectorsPerTrack;
        } else {
            sectorsPerTrack = 17L;
            cylinderTimesHeads = totalSectors / sectorsPerTrack;
            heads = (cylinderTimesHeads + 1023L) / 1024L;
            if (heads < 4L) {
                heads = 4L;
            }
            if (cylinderTimesHeads >= heads * 1024L || heads > 16L) {
                sectorsPerTrack = 31L;
                heads = 16L;
                cylinderTimesHeads = totalSectors / sectorsPerTrack;
            }
            if (cylinderTimesHeads >= heads * 1024L) {
                sectorsPerTrack = 63L;
                heads = 16L;
                cylinderTimesHeads = totalSectors / sectorsPerTrack;
            }
        }
        long cylinders = cylinderTimesHeads / heads;
        footer.putShort((short)cylinders);
        footer.put((byte)heads);
        footer.put((byte)sectorsPerTrack);
        footer.putInt(2);
        footer.putInt(0);
        footer.put(UuidUtils.fromUUID(UUID.randomUUID()));
        footer.put((byte)0);
        footer.put(new byte[427]);
        byte[] footerBytes = footer.array();
        long checksum = 0L;
        for (int pos = 0; pos < 512; ++pos) {
            checksum += (long)(footerBytes[pos] & 0xFF);
        }
        footer.putInt(64, (int)(checksum ^ 0xFFFFFFFFFFFFFFFFL));
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getMainFile()));){
            IOUtils.copyNoClose(this.image.getDiskImage(), (OutputStream)output);
            IOUtils.copyNoClose(new ByteArrayInputStream(footerBytes), (OutputStream)output);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to create VHD: " + e.getMessage());
        }
    }

    @Override
    public File getMainFile() {
        return new File(this.directory, this.image.getId() + ".vhd");
    }
}

