/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform;

import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.StopWatch;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.TimeFormat;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.client.core.internal.platform.AbstractInstance;
import com.boxfuse.client.core.internal.platform.DevVM;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.LaunchResult;
import com.boxfuse.client.core.internal.platform.LaunchResultImpl;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.client.core.internal.platform.Platform;
import com.boxfuse.generator.config.LogsFilters;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.repository.Repository;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlatform<I extends AbstractInstance>
implements Platform {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPlatform.class);
    protected final PlatformType type;
    protected final DevAgent devAgent;
    private final boolean platformOK;
    protected final File workDir;
    protected final Repository repository;

    protected AbstractPlatform(PlatformType type, File workDir, Repository repository, DevAgent devAgent, boolean platformOK) {
        this.type = type;
        this.devAgent = devAgent;
        this.platformOK = platformOK;
        this.workDir = new File(workDir.getAbsolutePath() + "/" + type.getName());
        ShellUtils.mkdir(this.workDir);
        this.repository = repository;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public PlatformType getType() {
        return this.type;
    }

    @Override
    public final LaunchResult run(AppType appType, Image image, LaunchSettings launchSettings, int instanceCount, DevVM devVM, Port devAgentPort, LogsFilters logFilters) {
        ArrayList<Instance> newInstances = new ArrayList<Instance>();
        ArrayList<I> instances = new ArrayList<I>();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (int n = 1; n <= instanceCount; ++n) {
            String counter = instanceCount == 1 ? "" : n + "/" + instanceCount + " ";
            LOGGER.info("Launching Instance " + counter + "of " + image + " on " + this + " ...");
            I instance = this.doLaunchInstance(image, launchSettings, devVM, devAgentPort, logFilters);
            instances.add(instance);
        }
        newInstances.addAll(instances);
        stopWatch.stop();
        LOGGER.info("Instance" + (instanceCount == 1 ? "" : "s") + " launched in " + TimeFormat.format(stopWatch.getTotalTimeMillis()) + " -> " + StringUtils.collectionToDelimitedString(instances, ", "));
        for (AbstractInstance instance : instances) {
            instance.waitForPayloadToStart(appType, launchSettings);
        }
        return new LaunchResultImpl(newInstances);
    }

    protected boolean isPlatformOK() {
        return this.platformOK;
    }

    protected abstract I doLaunchInstance(Image var1, LaunchSettings var2, DevVM var3, Port var4, LogsFilters var5);

    @Override
    public void kill(LaunchSettings launchSettings, List<Instance> instances) {
        if (instances.isEmpty()) {
            return;
        }
        LOGGER.info("Killing " + StringUtils.pluralize("Instance", instances.size()) + " " + StringUtils.collectionToDelimitedString(instances, ", ") + " on " + this + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.doDestroyInstances(instances);
        stopWatch.stop();
        LOGGER.info(StringUtils.pluralize("Instance", instances.size()) + " killed in " + TimeFormat.format(stopWatch.getTotalTimeMillis()));
    }

    @Override
    public void kill(LaunchSettings launchSettings, Instance ... instances) {
        this.kill(launchSettings, Arrays.asList(instances));
    }

    protected abstract void doDestroyInstances(List<Instance> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPlatform that = (AbstractPlatform)o;
        return this.type.equals((Object)that.type) && this.workDir.equals(that.workDir);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.workDir.hashCode();
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

