/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.client.core.internal.console.AppInfo;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.Platform;
import com.boxfuse.generator.app.App;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.inventory.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

public class AsciiTableInfo {
    private static final String RUNTIME = "Runtime";
    private static final String COMPONENT = "Component";
    private static final String DEFAULT = "Default";
    private static final String VERSIONS = "Other Versions";
    private static final String PAYLOAD = "Payload";
    private static final String PORTS = "Ports";
    private static final String SIZE = "Size";
    private static final String COL_SEPARATOR = " | ";
    private static final String INSTANCE = "Instance";
    private static final String IMAGE = "Image";
    private static final String AVAILABILITY_ZONE = "Availability Zone";
    private static final String LAUNCH_TIME = "Launched at";
    private static final String MSG_NO_IMAGES = "No Images found !";

    public String listLocalImages(Collection<Image> images, String filter) {
        int imageColumnWidth = IMAGE.length();
        int payloadColumnWidth = PAYLOAD.length();
        int runtimeColumnWidth = RUNTIME.length();
        int portsColumnWidth = PORTS.length();
        int sizeColumnWidth = SIZE.length();
        for (Image image : images) {
            imageColumnWidth = Math.max(imageColumnWidth, image.getCoordinates().toString().length());
            payloadColumnWidth = Math.max(payloadColumnWidth, this.getPayloadName(image).length());
            runtimeColumnWidth = Math.max(runtimeColumnWidth, this.getRuntime(image).length());
            portsColumnWidth = Math.max(portsColumnWidth, this.getPorts(image).length());
            sizeColumnWidth = Math.max(sizeColumnWidth, this.getSize(image).length());
        }
        String ruler = "+-" + StringUtils.trimOrPad("", imageColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", payloadColumnWidth, '-') + "-+-------+-" + StringUtils.trimOrPad("", runtimeColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", portsColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", sizeColumnWidth, '-') + "-+---------------------+\n";
        StringBuilder result = new StringBuilder();
        result.append("Images available locally").append(filter == null ? "" : " matching " + filter + " ").append(":\n");
        result.append(ruler);
        result.append("| ").append(StringUtils.trimOrPad(IMAGE, imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(PAYLOAD, payloadColumnWidth)).append(COL_SEPARATOR).append("Debug").append(COL_SEPARATOR).append(StringUtils.center(RUNTIME, runtimeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(PORTS, portsColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(SIZE, sizeColumnWidth)).append(" |    Generated at     |\n");
        result.append(ruler);
        if (images.isEmpty()) {
            result.append(StringUtils.trimOrPad("| No Images found !", ruler.length() - 2)).append("|\n");
        } else {
            for (Image image : images) {
                result.append("| ").append(StringUtils.trimOrPad(image.getCoordinates(), imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(this.getPayloadName(image), payloadColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad("" + image.isDebug(), 5)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(this.getRuntime(image), runtimeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(this.getPorts(image), portsColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrLeftPad(this.getSize(image), sizeColumnWidth, ' ')).append(COL_SEPARATOR).append(DateUtils.toLocalDateTimeString(image.getGeneratedUtc())).append(" |\n");
            }
        }
        result.append(ruler);
        result.append("Total: ").append(images.size()).append("\n");
        return result.toString();
    }

    private String getPayloadName(Image image) {
        return image.getPayload().getName();
    }

    String getPorts(Image image) {
        return StringUtils.mapToDelimitedString(image.getPorts(), ", ");
    }

    private String getSize(Image image) {
        return image.getSize() / 1024L + " K";
    }

    private String getRuntime(Image image) {
        PayloadType payloadType = image.getPayload().getType();
        if (Arrays.asList(PayloadType.LINUX_X64, PayloadType.REVEL).contains((Object)payloadType)) {
            return payloadType.getDescription();
        }
        Map<ComponentId, Version> components = image.getComponents();
        if (components.containsKey((Object)ComponentId.NODEJS)) {
            return "Node.js " + components.get((Object)ComponentId.NODEJS);
        }
        Version openjdkVersion = image.getComponents().get((Object)ComponentId.OPENJDK);
        if (openjdkVersion == null) {
            openjdkVersion = image.getComponents().get((Object)ComponentId.OPENJDK_COMPACT3);
        }
        String base = "Java";
        if (openjdkVersion != null) {
            base = base + " " + openjdkVersion;
        }
        if (components.containsKey((Object)ComponentId.TOMCAT)) {
            return base + " (Tomcat " + components.get((Object)ComponentId.TOMCAT) + ")";
        }
        base = base + " (" + (Object)((Object)payloadType);
        if (components.containsKey((Object)ComponentId.TOMEE_WEBPROFILE)) {
            return base + " " + components.get((Object)ComponentId.TOMEE_WEBPROFILE) + ")";
        }
        if (components.containsKey((Object)ComponentId.TOMEE_PLUS)) {
            return base + " " + components.get((Object)ComponentId.TOMEE_PLUS) + ")";
        }
        return base + ")";
    }

    private String toFilter(AppCoordinates appCoordinates, Version version) {
        String filter = null;
        if (appCoordinates != null) {
            filter = appCoordinates.toString();
            if (version != null) {
                filter = filter + ":" + version;
            }
        }
        return filter;
    }

    private String listLocalInstances(Collection<Instance> instances) {
        int imageColumnWidth = IMAGE.length();
        int typeColumnWidth = 4;
        int urlColumnWidth = 3;
        for (Instance instance : instances) {
            imageColumnWidth = Math.max(imageColumnWidth, instance.getImage().getCoordinates().toString().length());
            typeColumnWidth = Math.max(typeColumnWidth, instance.getType().length());
            urlColumnWidth = Math.max(urlColumnWidth, instance.getPayloadUrl() == null ? 0 : instance.getPayloadUrl().length());
        }
        String ruler = "+-------------+-" + StringUtils.trimOrPad("", imageColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", typeColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", urlColumnWidth, '-') + "-+---------------------+\n";
        StringBuilder result = new StringBuilder();
        result.append(ruler);
        result.append("|  Instance   | ").append(StringUtils.center(IMAGE, imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center("Type", typeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center("URL", urlColumnWidth)).append(" |     Launched at     |\n");
        result.append(ruler);
        if (instances.isEmpty()) {
            result.append(StringUtils.trimOrPad("| No running Instances found !", ruler.length() - 2)).append("|\n");
        } else {
            for (Instance instance : instances) {
                result.append("| ").append(StringUtils.trimOrPad(instance.getId(), 11)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.getImage().getCoordinates(), imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.getType(), typeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.getPayloadUrl(), urlColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad("" + DateUtils.toLocalDateTimeString(instance.getLaunchTime()), 19)).append(" |\n");
            }
        }
        result.append(ruler);
        return result.toString();
    }

    public String listVaultImages(Map<AppCoordinates, App> apps) {
        return this.doListVaultImages(apps, null);
    }

    public String listVaultImages(Map<AppCoordinates, App> apps, ImageCoordinates imageCoordinates) {
        return this.doListVaultImages(this.filter(apps, imageCoordinates.getAppCoordinates(), imageCoordinates.getVersion()), imageCoordinates.toString());
    }

    public String listVaultImages(Map<AppCoordinates, App> apps, AppCoordinates appCoordinates) {
        return this.doListVaultImages(this.filter(apps, appCoordinates, null), appCoordinates.toString());
    }

    private Map<AppCoordinates, App> filter(Map<AppCoordinates, App> apps, AppCoordinates appCoordinates, Version version) {
        TreeMap<AppCoordinates, App> filteredApps = new TreeMap<AppCoordinates, App>();
        for (Map.Entry<AppCoordinates, App> appEntry : apps.entrySet()) {
            if (!appEntry.getKey().equals(appCoordinates)) continue;
            App app = appEntry.getValue();
            TreeMap<Version, Integer> imagesFiltered = new TreeMap<Version, Integer>();
            if (version == null) {
                imagesFiltered.putAll(app.getImages());
            } else if (app.getImages().containsKey(version)) {
                imagesFiltered.put(version, (Integer)app.getImages().get(version));
            }
            if (imagesFiltered.isEmpty()) continue;
            filteredApps.put(appEntry.getKey(), new App(app.getCoordinates(), app.getAppType(), app.getDbType(), app.getLogsType(), app.getTlsType(), imagesFiltered));
        }
        return filteredApps;
    }

    private String doListVaultImages(Map<AppCoordinates, App> apps, String filter) {
        int imageColumnWidth = MSG_NO_IMAGES.length();
        int count = 0;
        for (Map.Entry<AppCoordinates, App> appEntry : apps.entrySet()) {
            App app = appEntry.getValue();
            for (Version version : app.getImages().keySet()) {
                ++count;
                imageColumnWidth = Math.max(imageColumnWidth, (appEntry.getKey() + ":" + version).length());
            }
        }
        String ruler = "+-" + StringUtils.trimOrPad("", imageColumnWidth, '-') + "-+\n";
        StringBuilder result = new StringBuilder();
        result.append("Images in the Boxfuse Vault").append(filter == null ? "" : " matching " + filter + " ").append(":\n");
        result.append(ruler);
        result.append("| ").append(StringUtils.trimOrPad(IMAGE, imageColumnWidth)).append(" |\n");
        result.append(ruler);
        if (count == 0) {
            result.append(StringUtils.trimOrPad("| No Images found !", ruler.length() - 2)).append("|\n");
        } else {
            for (Map.Entry<AppCoordinates, App> appEntry : apps.entrySet()) {
                App app = appEntry.getValue();
                for (Version version : app.getImages().keySet()) {
                    result.append("| ").append(StringUtils.trimOrPad(appEntry.getKey() + ":" + version, imageColumnWidth)).append(" |\n");
                }
            }
        }
        result.append(ruler);
        result.append("Total: ").append(count).append("\n");
        return result.toString();
    }

    public String listComponents(Map<ComponentId, SortedSet<Version>> versions, ComponentId filter, boolean online) {
        TreeMap<ComponentId, SortedSet<Version>> displayVersions = new TreeMap<ComponentId, SortedSet<Version>>(versions);
        displayVersions.remove((Object)ComponentId.BOXFUSE_DEV_HDD);
        int componentColumnWidth = COMPONENT.length();
        int defaultColumnWidth = DEFAULT.length();
        int versionColumnWidth = VERSIONS.length();
        int count = 0;
        for (ComponentId componentId : versions.keySet()) {
            componentColumnWidth = Math.max(componentColumnWidth, componentId.getId().length());
            SortedSet<Version> versionSet = versions.get((Object)componentId);
            Version defaultVersion = InventoryUtils.findDefaultVersion(versionSet);
            defaultColumnWidth = Math.max(defaultColumnWidth, defaultVersion.getVersion().length());
            String versionListAsString = this.getVersionListAsString(componentId, versionSet, defaultVersion);
            versionColumnWidth = Math.max(versionColumnWidth, versionListAsString.length());
            count += versionSet.size();
        }
        String ruler = "+-" + StringUtils.trimOrPad("", componentColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", defaultColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", versionColumnWidth, '-') + "-+\n";
        StringBuilder result = new StringBuilder();
        result.append("Component Versions ").append(online ? "in the Boxfuse Inventory" : "available locally").append(filter == null ? "" : " for " + (Object)((Object)filter)).append(":\n");
        result.append(ruler);
        result.append("| ").append(StringUtils.center(COMPONENT, componentColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(DEFAULT, defaultColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(VERSIONS, versionColumnWidth)).append(" |\n");
        result.append(ruler);
        if (count == 0) {
            result.append(StringUtils.trimOrPad("| No versions found !", ruler.length() - 2)).append("|\n");
        } else {
            for (ComponentId componentId : versions.keySet()) {
                String componentIdTrimmed = StringUtils.trimOrPad((Object)componentId, componentColumnWidth);
                SortedSet<Version> versionSet = versions.get((Object)componentId);
                Version defaultVersion = InventoryUtils.findDefaultVersion(versionSet);
                String latestTrimmed = StringUtils.trimOrPad(defaultVersion.getVersion(), defaultColumnWidth);
                String versionListAsString = this.getVersionListAsString(componentId, versionSet, defaultVersion);
                String versionListTrimmed = StringUtils.trimOrPad(versionListAsString, versionColumnWidth);
                result.append("| ").append(componentIdTrimmed).append(COL_SEPARATOR).append(latestTrimmed).append(COL_SEPARATOR).append(versionListTrimmed).append(" |\n");
            }
        }
        result.append(ruler);
        result.append("Total: ").append(count).append("\n");
        return result.toString();
    }

    private String getVersionListAsString(ComponentId componentId, SortedSet<Version> versionSet, Version defaultVersion) {
        if (componentId.getDirectFetchUrl(defaultVersion) == null) {
            ArrayList<Version> versionList = new ArrayList<Version>(versionSet);
            versionList.remove(defaultVersion);
            Collections.sort(versionList);
            Collections.reverse(versionList);
            return StringUtils.collectionToDelimitedString(versionList, " ");
        }
        return "Check " + this.getDirectFetchUrlBase(componentId);
    }

    String getDirectFetchUrlBase(ComponentId componentId) {
        Version defaultVersion = componentId.getDefaultVersion();
        String directFetchUrl = componentId.getDirectFetchUrl(defaultVersion);
        String urlNoVersion = directFetchUrl.substring(0, directFetchUrl.indexOf(defaultVersion.getVersion()));
        return urlNoVersion.substring(0, urlNoVersion.lastIndexOf("/") + 1);
    }

    public String ps(Platform platform, Collection<InstanceId> instanceIds) {
        return this.doPs(platform, StringUtils.collectionToDelimitedString(instanceIds, ","), platform.getInstances(instanceIds));
    }

    public String ps(Platform platform, AppCoordinates appCoordinates, Version version) {
        String filter = this.toFilter(appCoordinates, version);
        List<Instance> instances = platform.runningInstances();
        ArrayList<Instance> filteredInstances = new ArrayList<Instance>();
        if (appCoordinates == null) {
            filteredInstances.addAll(instances);
        } else {
            for (Instance instance : instances) {
                ImageCoordinates coordinates = instance.getImage().getCoordinates();
                if (!coordinates.getAppCoordinates().equals(appCoordinates) || version != null && !coordinates.getVersion().equals(version)) continue;
                filteredInstances.add(instance);
            }
        }
        return this.doPs(platform, filter, filteredInstances);
    }

    private String doPs(Platform platform, String filter, Collection<Instance> filteredInstances) {
        String result = "Running Instances on " + platform + " in the dev environment" + (filter == null ? "" : " for " + filter) + " :\n";
        result = result + this.listLocalInstances(filteredInstances);
        result = result + "Total: " + filteredInstances.size() + "\n";
        return result;
    }

    public String psProd(EnvName env, List<Map<String, Object>> instances, AppCoordinates appCoordinates, Version version) {
        String filter = this.toFilter(appCoordinates, version);
        return this.doPsProd(env, instances, filter);
    }

    public String psProd(EnvName env, List<Map<String, Object>> instances, InstanceId instanceId) {
        return this.doPsProd(env, instances, instanceId.getId());
    }

    private String doPsProd(EnvName env, List<Map<String, Object>> instances, String filter) {
        StringBuilder result = new StringBuilder("Running Instances on AWS in the " + env + " environment" + (filter == null ? "" : " for " + filter) + " :\n");
        int instanceColumnWidth = INSTANCE.length();
        int imageColumnWidth = IMAGE.length();
        int typeColumnWidth = 4;
        int availabilityZoneColumnWidth = AVAILABILITY_ZONE.length();
        int launchTimeColumnWidth = LAUNCH_TIME.length();
        for (Map<String, Object> instance : instances) {
            instanceColumnWidth = Math.max(instanceColumnWidth, instance.get("id").toString().length());
            imageColumnWidth = Math.max(imageColumnWidth, instance.get("image").toString().length());
            typeColumnWidth = Math.max(typeColumnWidth, instance.get("type").toString().length());
            availabilityZoneColumnWidth = Math.max(availabilityZoneColumnWidth, instance.get("availabilityZone").toString().length());
            launchTimeColumnWidth = Math.max(launchTimeColumnWidth, instance.get("launchTime").toString().length());
        }
        String ruler = "+-" + StringUtils.trimOrPad("", instanceColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", imageColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", typeColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", availabilityZoneColumnWidth, '-') + "-+-" + StringUtils.trimOrPad("", launchTimeColumnWidth, '-') + "-+\n";
        result.append(ruler);
        result.append("| ").append(StringUtils.center(INSTANCE, instanceColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(IMAGE, imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center("Type", typeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(AVAILABILITY_ZONE, availabilityZoneColumnWidth)).append(COL_SEPARATOR).append(StringUtils.center(LAUNCH_TIME, launchTimeColumnWidth)).append(" |\n");
        result.append(ruler);
        if (instances.isEmpty()) {
            result.append(StringUtils.trimOrPad("| No running Instances found !", ruler.length() - 2)).append("|\n");
        } else {
            for (Map<String, Object> instance : instances) {
                result.append("| ").append(StringUtils.trimOrPad(instance.get("id"), instanceColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.get("image"), imageColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.get("type"), typeColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.get("availabilityZone"), availabilityZoneColumnWidth)).append(COL_SEPARATOR).append(StringUtils.trimOrPad(instance.get("launchTime"), launchTimeColumnWidth)).append(" |\n");
            }
        }
        result.append(ruler);
        return result.toString();
    }

    public String info(AppInfo appInfo, EnvName env, AppType appType, DbType dbType, LogsType logsType) {
        StringBuilder result = new StringBuilder();
        result.append("Info about ").append(appInfo.getCoordinates()).append(" in the ").append(env).append(" environment:\n");
        result.append("\n");
        result.append("App Type    : ").append(appType.getDescription()).append("\n");
        if (appInfo.getUrl() != null) {
            result.append("App URL     : ").append(appInfo.getUrl()).append("\n");
        }
        result.append("DB Type     : ").append(dbType.getDescription()).append("\n");
        if (DbType.NONE != dbType && appInfo.getDbPort() != null) {
            result.append("DB URL      : jdbc:").append(dbType.getName()).append("://").append(appInfo.getDbHost()).append(":").append(appInfo.getDbPort()).append("/").append(appInfo.getDbDatabase()).append("\n");
            result.append("DB Host     : ").append(appInfo.getDbHost()).append("\n");
            result.append("DB Port     : ").append(appInfo.getDbPort()).append("\n");
            result.append("DB Database : ").append(appInfo.getDbDatabase()).append("\n");
            result.append("DB User     : ").append(appInfo.getDbUser()).append("\n");
            result.append("DB Password : ").append(appInfo.getDbPassword()).append("\n");
            result.append("DB Status   : ").append(appInfo.getDbStatus()).append("\n");
        }
        result.append("Logs Type   : ").append(logsType.getDescription());
        return result.toString();
    }
}

