/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.hyperv;

import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformHealth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperVInstallation {
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperVInstallation.class);
    private final LocalPlatformHealth health;
    private static HyperVInstallation installation;

    private HyperVInstallation(LocalPlatformHealth health) {
        this.health = health;
    }

    public LocalPlatformHealth getHealth() {
        return this.health;
    }

    public static HyperVInstallation get() {
        if (installation == null) {
            installation = HyperVInstallation.computeHyperVInstallationDetails();
        }
        return installation;
    }

    private static HyperVInstallation computeHyperVInstallationDetails() {
        if (!OSUtils.runningOnWindows() || HyperVInstallation.isWindowsHomeEdition()) {
            return new HyperVInstallation(LocalPlatformHealth.UNSUPPORTED_OS);
        }
        if (!HyperVInstallation.isHyperVInstalled()) {
            return new HyperVInstallation(LocalPlatformHealth.NOT_INSTALLED);
        }
        if (!HyperVInstallation.isHyperVAdministrator()) {
            return new HyperVInstallation(LocalPlatformHealth.NOT_ADMIN);
        }
        return new HyperVInstallation(LocalPlatformHealth.OK);
    }

    static boolean isWindowsHomeEdition() {
        return ShellUtils.execCommand("reg", "query", "HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "/v", "ProductName").contains("Home");
    }

    private static boolean isHyperVInstalled() {
        return HyperVInstallation.powershellCmdletExists("Get-VM");
    }

    static boolean powershellCmdletExists(String cmdlet) {
        try {
            return ShellUtils.execCommand("powershell", "if (Get-Command " + cmdlet + " -errorAction SilentlyContinue) { echo OK }").contains("OK");
        }
        catch (Exception e) {
            LOGGER.debug("Error while attempting to detect PowerShell " + cmdlet + ": " + e.getMessage());
            return false;
        }
    }

    static boolean isHyperVAdministrator() {
        return ShellUtils.execCommand("whoami", "/groups", "/fo", "csv", "/nh").contains("S-1-5-32-578");
    }

    public String getInfo() {
        return this.health.toString();
    }
}

