/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.error.YAMLException;

public class DropwizardRamDiskBuilder
extends JarRamDiskBuilder<DropwizardPayload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardRamDiskBuilder.class);
    private static final String CONFIG_FILE = "boxfuse.yml";
    private static final byte[] DEFAULT_CONFIG = IOUtils.copyToByteArray("generator/dropwizard/boxfuse.yml");
    private static final byte[] DEFAULT_TLS_CONFIG = IOUtils.copyToByteArray("generator/dropwizard/boxfuse-tls.yml");
    private byte[] boxfuseYmlBytes;
    private boolean defaultConfig;

    public DropwizardRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        super.installPayloadWithDependencies();
        if (this.defaultConfig) {
            this.ramDisk.createFile("app-config/boxfuse.yml", false, this.boxfuseYmlBytes);
        }
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        DropwizardConfig dropwizardConfig;
        this.boxfuseYmlBytes = ((DropwizardPayload)this.payload).getBoxfuseYml();
        if (this.boxfuseYmlBytes != null) {
            if (!this.messagesDisplayed) {
                LOGGER.debug("Found boxfuse.yml in jar file");
            }
        } else {
            if (!this.messagesDisplayed) {
                LOGGER.debug("Unable to find boxfuse.yml in jar file => using default configuration file");
            }
            this.useDefaultConfig();
        }
        try {
            dropwizardConfig = new DropwizardConfig(new String(this.boxfuseYmlBytes, StandardCharsets.UTF_8));
        }
        catch (YAMLException e) {
            if (!this.messagesDisplayed) {
                LOGGER.warn("Invalid Dropwizard config file boxfuse.yml (" + e.getMessage() + ") => falling back to default configuration file");
            }
            this.useDefaultConfig();
            dropwizardConfig = new DropwizardConfig(new String(this.boxfuseYmlBytes, StandardCharsets.UTF_8));
        }
        for (Map.Entry<PortName, Port> portEntry : dropwizardConfig.getPorts().entrySet()) {
            if (this.spec.getPorts().containsKey(portEntry.getKey())) continue;
            this.spec.getPorts().put(portEntry.getKey(), portEntry.getValue());
            if (this.messagesDisplayed) continue;
            LOGGER.debug("Auto-configured " + portEntry.getKey().getName() + " port to " + portEntry.getValue());
        }
        if (this.spec.getPayloadPath() == null) {
            this.spec.setPayloadPath(dropwizardConfig.getPayloadPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured payload path to " + this.spec.getPayloadPath());
            }
        }
        if (this.spec.getHealthcheckPath() == null) {
            this.spec.setHealthcheckPath(dropwizardConfig.getHealthcheckPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured healthcheck path to " + this.spec.getHealthcheckPath());
            }
        }
        super.doAdjustSpecBasedOnConfig();
    }

    private void useDefaultConfig() {
        this.boxfuseYmlBytes = this.spec.getTlsType() == TlsType.ACM ? DEFAULT_TLS_CONFIG : DEFAULT_CONFIG;
        this.defaultConfig = true;
    }

    @Override
    protected String computeJvmExtraArgs() {
        String extraArgs = "";
        DbType dbType = this.spec.getDbType();
        if (dbType != null && DbType.NONE != dbType) {
            extraArgs = extraArgs + "\"-Ddw.database.driverClass=" + dbType.getJdbcDriverClass() + "\" \"-Ddw.database.url=$BOXFUSE_DATABASE_URL\" \"-Ddw.database.user=$BOXFUSE_DATABASE_USER\" \"-Ddw.database.password=$BOXFUSE_DATABASE_PASSWORD\" ";
        }
        return extraArgs + " " + super.computeJvmExtraArgs();
    }

    @Override
    protected void adjustEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        super.adjustEnvVars(envVars);
        this.putIfAbsent(envVars, EnvVarName.BOXFUSE_JVM_MAIN_ARGS, EnvVarValue.asIs("server " + (this.defaultConfig ? "/app-config/" : "") + CONFIG_FILE));
    }
}

