/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.config;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLevel;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.generator.config.InstanceId;
import java.util.Map;
import java.util.TreeMap;

public class LogsFilters {
    private final Map<LogsFieldName, Object> filters = new TreeMap<LogsFieldName, Object>();
    private final Owner owner;

    public LogsFilters(Owner owner) {
        this.owner = owner;
    }

    public void addFilter(LogsFieldName name, String value) {
        Object filterValue;
        switch (name) {
            case INSTANCE: {
                filterValue = new InstanceId(value);
                break;
            }
            case IMAGE: {
                filterValue = new ImageCoordinates(value, this.owner);
                break;
            }
            case APP: {
                filterValue = new AppCoordinates(value, this.owner);
                break;
            }
            case LEVEL: {
                filterValue = LogsLevel.fromValue(value);
                break;
            }
            case LIMIT: {
                filterValue = this.parseLimit(value);
                break;
            }
            case START: 
            case END: {
                filterValue = DateUtils.toDateTimeFlexible(value).getTime();
                break;
            }
            default: {
                filterValue = value;
            }
        }
        this.filters.put(name, filterValue);
        if (this.filters.containsKey((Object)LogsFieldName.START) && this.filters.containsKey((Object)LogsFieldName.END) && (Long)this.filters.get((Object)LogsFieldName.START) > (Long)this.filters.get((Object)LogsFieldName.END)) {
            throw new BoxfuseException("Logs filter start date cannot be after end date => correct or delete either one");
        }
    }

    public void addInstanceFilter(InstanceId instanceId) {
        if (instanceId != null) {
            this.filters.put(LogsFieldName.INSTANCE, instanceId);
        }
    }

    public void addAppFilter(AppCoordinates appCoordinates) {
        if (appCoordinates != null) {
            this.filters.put(LogsFieldName.APP, appCoordinates);
        }
    }

    private Long parseLimit(String value) {
        long limit;
        try {
            limit = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new BoxfuseException("Invalid logs limit (must be a number between 1 and 10000): " + value);
        }
        if (limit < 1L || limit > 10000L) {
            throw new BoxfuseException("Invalid logs limit (must be a number between 1 and 10000): " + value);
        }
        return limit;
    }

    public Map<LogsFieldName, Object> getFilters() {
        return this.filters;
    }
}

