/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.payload;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.payload.AbstractPayload;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PhysicalPayload
extends AbstractPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalPayload.class);
    protected final File file;
    protected final Map<String, PayloadEntry> entries;
    protected final String name;
    private AppName appName;
    private Version version;

    protected PhysicalPayload(File file, Map<String, PayloadEntry> entries) {
        this.file = file;
        this.name = file.getName();
        this.entries = entries;
    }

    public Map<String, PayloadEntry> getEntries() {
        return this.entries;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AppName extractAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        String appNameStr = StringUtils.firstMatchingGroup(this.name, "(.*)-[0-9].*");
        if (appNameStr == null && (appNameStr = StringUtils.firstMatchingGroup(this.name, "(.*)\\.[a-zA-Z]+\\.[a-zA-Z]+")) == null && (appNameStr = StringUtils.firstMatchingGroup(this.name, "(.*)\\.[a-zA-Z]+")) == null) {
            appNameStr = this.name;
        }
        if (AppName.validate(appNameStr)) {
            this.appName = AppName.of(appNameStr);
        } else {
            String appNameSimplified = PhysicalPayload.simplifyAppName(appNameStr);
            if (appNameSimplified.length() > 0) {
                LOGGER.warn("WARNING: Invalid App name (may only contain a-z, 0-9 and single dashes): " + this.appName + " => use image or app to set, falling back to auto-generated App name for now: " + appNameSimplified);
                this.appName = AppName.of(appNameSimplified);
            } else {
                this.appName = AppName.of("nonameapp");
                LOGGER.warn("WARNING: Unable to detect App name for payload " + this.name + " => use image or app to set, falling back to auto-generated App name for now: " + this.appName);
            }
        }
        return this.appName;
    }

    static String simplifyAppName(String appName) {
        String appNameSimplified = appName.toLowerCase().replaceAll("[^a-z\\-0-9]", "").replace("--", "-");
        while (appNameSimplified.endsWith("-")) {
            appNameSimplified = appNameSimplified.substring(0, appNameSimplified.length() - 1);
        }
        return appNameSimplified;
    }

    @Override
    public Version extractVersion(boolean fallback) {
        if (this.version == null) {
            String v = StringUtils.firstMatchingGroup(this.name, ".*-([0-9].*)\\.[a-zA-Z]+");
            if (v == null && (v = StringUtils.firstMatchingGroup(this.name, ".*-([0-9].*)")) == null) {
                if (!fallback) {
                    return null;
                }
                this.version = Version.generateFallbackVersion();
                LOGGER.warn("WARNING: Unable to detect version for payload " + this.name + " => use image to set, falling back to auto-generated version for now: " + this.version);
                return this.version;
            }
            if (v.endsWith(".tar")) {
                v = v.substring(0, v.lastIndexOf(".tar"));
            }
            try {
                this.version = new Version(v);
            }
            catch (BoxfuseException e) {
                if (!fallback) {
                    return null;
                }
                this.version = Version.generateFallbackVersion();
                LOGGER.warn("WARNING: Invalid Image version (may only contain numbers and dots): " + v + " => use image to set, falling back to auto-generated version for now: " + this.version);
            }
        }
        return this.version;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.getName() + " (" + StringUtils.intToHex(this.getChecksum()) + ", " + (Object)((Object)this.getType()) + ")";
    }
}

