/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mariadb.jdbc.AbstractCallableFunctionStatement;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;

public class MariaDbFunctionStatement
extends AbstractCallableFunctionStatement
implements CloneableCallableStatement {
    private MariaSelectResultSet outputResultSet = null;

    public MariaDbFunctionStatement(MariaDbConnection connection, String databaseName, String procedureName, String arguments) throws SQLException {
        super(connection, "SELECT " + procedureName + (arguments == null ? "()" : arguments), 1003);
        this.parameterMetadata = new CallableParameterMetaData(connection, databaseName, procedureName, true);
        super.initFunctionData(this.getParameterCount() + 1);
    }

    @Override
    protected MariaSelectResultSet getResult() throws SQLException {
        if (this.outputResultSet == null) {
            throw new SQLException("No output result");
        }
        return this.outputResultSet;
    }

    @Override
    public MariaDbFunctionStatement clone() throws CloneNotSupportedException {
        MariaDbFunctionStatement clone = (MariaDbFunctionStatement)super.clone();
        clone.outputResultSet = null;
        return clone;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.connection.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            if (this.executionResult != null && this.executionResult.getResult() == null) {
                int n = 0;
                return n;
            }
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.executionResult.getResult();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        super.setParameter(parameterIndex - 1, holder);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.connection.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            if (this.executionResult != null && this.executionResult.getResult() == null) {
                MariaSelectResultSet mariaSelectResultSet = this.executionResult.getResult();
                return mariaSelectResultSet;
            }
            MariaSelectResultSet mariaSelectResultSet = MariaSelectResultSet.EMPTY;
            return mariaSelectResultSet;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.connection.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            boolean bl = this.executionResult != null && this.executionResult.getResult() == null;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }
}

