/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;

public class AwsALBName {
    public static final AwsALBName AUTO = new AwsALBName("auto");
    private static final int ALB_NAME_MAX_LENGTH = 32;
    private final String name;

    @JsonCreator
    public static AwsALBName of(String name) {
        if (name == null) {
            return null;
        }
        if (AwsALBName.AUTO.name.equals(name)) {
            return AUTO;
        }
        return new AwsALBName(name);
    }

    private AwsALBName(String name) {
        if (!StringUtils.hasLength(name)) {
            throw new BoxfuseException("ALB name may not be empty");
        }
        if (name.length() > 32) {
            throw new BoxfuseException("Invalid ALB name (" + name + ") => Ensure it has a maximum length of " + 32 + " characters");
        }
        if (!name.matches("[A-Za-z0-9]([A-Za-z0-9\\-]{0,30}[A-Za-z0-9])?")) {
            throw new BoxfuseException("Invalid ALB name (" + name + ") => Ensure it contains only alphanumeric characters or hyphens, and does not begin or end with a hyphen");
        }
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsALBName that = (AwsALBName)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static AwsALBName generateUnique(List<AwsALBName> loadBalancerNames, String baseName) {
        String loadBalancerName = baseName;
        if (loadBalancerName.length() > 32) {
            loadBalancerName = loadBalancerName.substring(0, 32);
        }
        while (loadBalancerName.endsWith("-")) {
            loadBalancerName = loadBalancerName.substring(0, loadBalancerName.length() - 1);
        }
        String originalName = loadBalancerName;
        AwsALBName awsELBName = new AwsALBName(loadBalancerName);
        int counter = 0;
        while (loadBalancerNames.contains(awsELBName)) {
            awsELBName = new AwsALBName(originalName.substring(0, originalName.length() - 4) + String.format("%04d", counter++));
        }
        return awsELBName;
    }
}

