/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.logs.cloudwatchlogs;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.util.Locale;

public enum LogsLevel {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public static LogsLevel fromValue(String value) {
        String val = value.toUpperCase(Locale.ENGLISH);
        for (LogsLevel logsLevel : LogsLevel.values()) {
            if (!val.equals(logsLevel.name())) continue;
            return logsLevel;
        }
        throw new BoxfuseException("Unknown log level: " + value + " => possible choices: " + StringUtils.arrayToDelimitedString((Object[])LogsLevel.values(), ", "));
    }

    public String toFilterPattern() {
        String filterPattern = "";
        switch (this) {
            case TRACE: {
                filterPattern = filterPattern + "($.level = \"" + (Object)((Object)TRACE) + "\" || $.level = \"" + (Object)((Object)DEBUG) + "\" || $.level = \"" + (Object)((Object)INFO) + "\" || $.level = \"" + (Object)((Object)WARN) + "\" || $.level = \"" + (Object)((Object)ERROR) + "\")";
                break;
            }
            case DEBUG: {
                filterPattern = filterPattern + "($.level = \"" + (Object)((Object)DEBUG) + "\" || $.level = \"" + (Object)((Object)INFO) + "\" || $.level = \"" + (Object)((Object)WARN) + "\" || $.level = \"" + (Object)((Object)ERROR) + "\")";
                break;
            }
            case INFO: {
                filterPattern = filterPattern + "($.level = \"" + (Object)((Object)INFO) + "\" || $.level = \"" + (Object)((Object)WARN) + "\" || $.level = \"" + (Object)((Object)ERROR) + "\")";
                break;
            }
            case WARN: {
                filterPattern = filterPattern + "($.level = \"" + (Object)((Object)WARN) + "\" || $.level = \"" + (Object)((Object)ERROR) + "\")";
                break;
            }
            case ERROR: {
                filterPattern = filterPattern + "($.level = \"" + (Object)((Object)ERROR) + "\")";
            }
        }
        return filterPattern;
    }
}

