/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collection;

public enum ComponentId {
    BOXFUSE_DEV_HDD("boxfuse-dev-hdd", "vmdk.xz", "2016.02.09", "2016.02.09", new ComponentId[0]),
    BUSYBOX("busybox", "tar.gz", "1.22.1.012", "1.22.1.012", new ComponentId[0]),
    CACERTS("cacerts", "tar.gz", "2024.01.20", new ComponentId[0]),
    FREETYPE("freetype", "tar.gz", "2.6", new ComponentId[0]),
    GLIBC("glibc", "tar.gz", "2.21", new ComponentId[0]),
    LIBGCC("libgcc", "tar.gz", "4.9.2", new ComponentId[0]),
    LIBPNG("libpng", "tar.gz", "1.2.52", new ComponentId[0]),
    LINUX("linux", "tar.gz", "4.14.14", "4.14.14", new ComponentId[0]),
    NEWRELIC_JAVA("newrelic-java", "zip", "3.11.0", "7.4.0", "https://download.newrelic.com/newrelic/java-agent/newrelic-agent/%s/newrelic-java-%s.zip", new ComponentId[0]),
    NEWRELIC_SYSMOND("newrelic-sysmond", "tar.gz", "2.0.2.111", "2.3.0.132", "https://download.newrelic.com/server_monitor/archive/%s/newrelic-sysmond-%s-linux.tar.gz", new ComponentId[0]),
    NODEJS("nodejs", "tar.xz", "0.10.45", "8.9.4", "https://nodejs.org/dist/v%s/node-v%s-linux-x64.tar.xz", new ComponentId[0]),
    OPENJDK("openjdk", "tar.gz", new Version("7.55.14"), "25.0.99", "17.0.7"),
    OPENJDK_COMPACT3("openjdk-compact3", "tar.gz", "8.40.25", OPENJDK),
    SPRINGLOADED("springloaded", "jar", "1.2.0", "1.2.7", "https://repo.spring.io/release/org/springframework/springloaded/%s.RELEASE/springloaded-%s.RELEASE.jar", new ComponentId[0]),
    STRACE("strace", "tar.gz", "4.5.20", new ComponentId[0]),
    TOMCAT("tomcat", "zip", "7.0.42", "8.5.24", "https://archive.apache.org/dist/tomcat/tomcat-%s/v%s/bin/apache-tomcat-%s.zip", new ComponentId[0]){

        @Override
        public String getDirectFetchUrl(Version version) {
            return String.format("https://archive.apache.org/dist/tomcat/tomcat-%s/v%s/bin/apache-tomcat-%s.zip", version.getVersion().substring(0, 1), version, version);
        }
    }
    ,
    TOMEE_WEBPROFILE("tomee-webprofile", "zip", "1.7.2", "7.0.3", "https://archive.apache.org/dist/tomee/tomee-%s/apache-tomee-%s-webprofile.zip", TOMCAT),
    TOMEE_PLUS("tomee-plus", "zip", "1.7.2", "7.0.3", "https://archive.apache.org/dist/tomee/tomee-%s/apache-tomee-%s-plus.zip", TOMEE_WEBPROFILE, TOMCAT),
    TTF_BITSTREAM_VERA("ttf-bitstream-vera", "tar.gz", "1.10", new ComponentId[0]),
    VBOXSF("vboxsf", "tar.gz", "4.14.14", "4.14.14", new ComponentId[0]),
    ZLIB("zlib", "tar.gz", "1.2.8", new ComponentId[0]);

    private final String id;
    private final String format;
    private final Version minVersion;
    private final Version maxVersion;
    private final Version defaultVersion;
    private final String directFetchUrlTemplate;
    private final Collection<ComponentId> overridenComponents;

    private ComponentId(String id, String format, String minVersion, String defaultVersion, String directFetchUrlTemplate, ComponentId ... overridenComponents) {
        this(id, format, new Version(minVersion), null, defaultVersion, directFetchUrlTemplate, overridenComponents);
    }

    private ComponentId(String id, String format, String minVersion, ComponentId ... overridenComponents) {
        this(id, format, new Version(minVersion), null, null, null, overridenComponents);
    }

    private ComponentId(String id, String format, String minVersion, String maxVersion, ComponentId ... overridenComponents) {
        this(id, format, new Version(minVersion), maxVersion, null, null, overridenComponents);
    }

    private ComponentId(String id, String format, Version minVersion, String maxVersion, String defaultVersion) {
        this(id, format, minVersion, maxVersion, defaultVersion, null, new ComponentId[0]);
    }

    private ComponentId(String id, String format, Version minVersion, String maxVersion, String defaultVersion, String directFetchUrlTemplate, ComponentId ... overridenComponents) {
        this.id = id;
        this.format = format;
        this.minVersion = minVersion;
        Version version = this.maxVersion = maxVersion == null ? Version.MAX_VERSION : new Version(maxVersion);
        this.defaultVersion = defaultVersion == null ? (maxVersion == null ? null : this.maxVersion) : new Version(defaultVersion);
        this.directFetchUrlTemplate = directFetchUrlTemplate;
        this.overridenComponents = Arrays.asList(overridenComponents);
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    public String getFormat() {
        return this.format;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public Version getDefaultVersion() {
        return this.defaultVersion;
    }

    public String getDirectFetchUrl(Version version) {
        if (this.directFetchUrlTemplate == null) {
            return null;
        }
        return String.format(this.directFetchUrlTemplate, version, version);
    }

    public Collection<ComponentId> getOverridenComponents() {
        return this.overridenComponents;
    }

    public String toString() {
        return this.id;
    }

    @JsonCreator
    public static ComponentId of(String id) {
        if (id == null) {
            return null;
        }
        return ComponentId.of(id, true);
    }

    public static ComponentId of(String id, boolean failIfUnknown) {
        if (id == null) {
            throw new BoxfuseException("Missing component -> must be one of " + StringUtils.arrayToDelimitedString((Object[])ComponentId.values(), ", "));
        }
        for (ComponentId componentId : ComponentId.values()) {
            if (!componentId.getId().equals(id)) continue;
            return componentId;
        }
        if (failIfUnknown) {
            throw new BoxfuseException("Unknown component: " + id + " -> must be one of " + StringUtils.arrayToDelimitedString((Object[])ComponentId.values(), ", "));
        }
        return null;
    }
}

