/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonValue;

public abstract class RestrictedInteger<T extends RestrictedInteger>
implements Comparable<T> {
    protected final int value;

    protected RestrictedInteger(String value, String field, String unit, int min, int max) {
        this.value = this.validateBounds(value, field, unit, min, max);
    }

    private int validateBounds(String value, String field, String unit, int min, int max) {
        int val;
        try {
            val = Integer.valueOf(value);
            if (val < min || val > max) {
                throw new IllegalArgumentException(value);
            }
        }
        catch (Exception e) {
            throw new BoxfuseException("Invalid " + field + (unit == null ? "" : " (in " + unit + ")") + ": " + value + " => must be between " + min + " and " + max);
        }
        return val;
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedInteger that = (RestrictedInteger)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(T o) {
        return this.value - ((RestrictedInteger)o).value;
    }

    public String toString() {
        return "" + this.value;
    }
}

