/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static Pattern splitPattern = Pattern.compile("\\.(?=\\d)");
    public static final Version MAX_VERSION = new Version("999999999999");
    private final List<BigInteger> versionParts;
    private final String milestone;
    private final String version;

    @JsonCreator
    public Version(String version) {
        this(version, false);
    }

    public Version(String version, boolean milestonesAllowed) {
        String versionToParse = version;
        if (milestonesAllowed) {
            if (version.endsWith("-")) {
                throw new BoxfuseException("Invalid version containing ending with a dash (-): " + version + " => Only 0..9 and . are allowed (Examples: 1.23.456 or 78) as well as a single alphanumeric milestone (say M2) as in 1.23.456-M2");
            }
            int i = version.indexOf("-");
            if (i > 0) {
                this.milestone = version.substring(i + 1);
                if (!this.milestone.matches("[A-Za-z0-9]+")) {
                    throw new BoxfuseException("Invalid version milestone: " + version + " => Only 0..9 and . are allowed (Examples: 1.23.456 or 78) as well as a single alphanumeric milestone (say M2) as in 1.23.456-M2");
                }
                versionToParse = version.substring(0, i);
            } else {
                this.milestone = null;
            }
        } else {
            this.milestone = null;
        }
        this.versionParts = this.tokenize(versionToParse);
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    @JsonValue
    public String getVersion() {
        return this.version;
    }

    public boolean isMilestone() {
        return this.milestone != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version1 = (Version)o;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        List<BigInteger> elements1 = this.versionParts;
        List<BigInteger> elements2 = o.versionParts;
        int largestNumberOfElements = Math.max(elements1.size(), elements2.size());
        for (int i = 0; i < largestNumberOfElements; ++i) {
            int compared = this.getOrZero(elements1, i).compareTo(this.getOrZero(elements2, i));
            if (compared == 0) continue;
            return compared;
        }
        if (Objects.equals(this.milestone, o.milestone)) {
            return 0;
        }
        if (this.milestone == null) {
            return 1;
        }
        if (o.milestone == null) {
            return -1;
        }
        return this.milestone.compareTo(o.milestone);
    }

    private BigInteger getOrZero(List<BigInteger> elements, int i) {
        return i < elements.size() ? elements.get(i) : BigInteger.ZERO;
    }

    private List<BigInteger> tokenize(String str) {
        if (!str.matches("[0-9][0-9\\.]*") || str.endsWith(".") || str.contains("..")) {
            throw new BoxfuseException("Invalid version containing non-numeric characters: " + str + " => Only 0..9 and . are allowed (Examples: 1.23.456 or 78)");
        }
        ArrayList<BigInteger> numbers = new ArrayList<BigInteger>();
        for (String number : splitPattern.split(str)) {
            numbers.add(new BigInteger(number));
        }
        for (int i = numbers.size() - 1; i > 0 && ((BigInteger)numbers.get(i)).equals(BigInteger.ZERO); --i) {
            numbers.remove(i);
        }
        return numbers;
    }

    public static synchronized Version generateFallbackVersion() {
        return new Version("0.0.0." + System.currentTimeMillis());
    }
}

