/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator;

import com.boxfuse.base.bootable.BootableDiskImageBuilder;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.metadata.ImageMetadata;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.util.BusyIndicator;
import com.boxfuse.base.util.ChecksumUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.IdUtils;
import com.boxfuse.base.util.ParallelGZIPOutputStream;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.StopWatch;
import com.boxfuse.base.util.TimeFormat;
import com.boxfuse.generator.builder.ImageBuilder;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.RamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.generic.GenericRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.generic.go.revel.RevelRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.tomee.TomeeRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsRamDiskBuilder;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.image.spec.ImageSpec;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import com.boxfuse.generator.repository.Repository;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Generator.class);
    private static final int KB = 1024;
    private static final int FILE_STREAM_BUFFER_SIZE = 262144;
    private static final int MB = 0x100000;
    private final CertificateManager certificateManager;
    private final Inventory inventory;
    private final Repository repository;
    private final PrivateKey privateKey;
    private final ImageSpecImpl spec;
    private final RamDiskBuilder ramDiskBuilder;
    private final BootableDiskImageBuilder bootableDiskImageBuilder;
    private final ImageMetadata metadata;

    public Generator(CertificateManager certificateManager, Inventory inventory, Repository repository, PrivateKey privateKey, ImageSpecImpl spec) {
        this.certificateManager = certificateManager;
        this.inventory = inventory;
        this.repository = repository;
        this.privateKey = privateKey;
        this.spec = spec;
        this.bootableDiskImageBuilder = new BootableDiskImageBuilder(spec.getLinuxArgs());
        this.ramDiskBuilder = this.createRamDiskBuilder(Collections.singletonList(inventory.get(ComponentId.LINUX, spec.getComponents().get(ComponentId.LINUX))));
        this.ramDiskBuilder.adjustSpecBasedOnConfig();
        spec.validate();
        this.metadata = Generator.toImageMetadata(spec, this.ramDiskBuilder.getComponents());
    }

    public int fingerprint() {
        return this.metadata.fingerprint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generate(File workDir) {
        String debugMsg = this.spec.isDebug() ? " (debug mode)" : "";
        LOGGER.info("Fusing Image for " + this.spec.getPayload().getName() + " (" + this.spec.getPayload().getType() + ")" + debugMsg + " ...");
        BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.start();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String id = IdUtils.generateGloballyUniqueId((String)"ba");
        Date generationTime = new Date();
        try {
            block8: {
                block7: {
                    this.printHeapUsage();
                    if (workDir == null || this.spec.getPayload().size() <= 0x8000000L) break block7;
                    File generatorDir = new File(workDir, "Generator");
                    ShellUtils.mkdir((File)generatorDir);
                    File initRdGz = null;
                    File virtual = null;
                    File virtualGz = null;
                    try {
                        initRdGz = new File(generatorDir, id + ".initrd.gz");
                        LOGGER.trace("Start RAM");
                        this.ramDiskBuilder.build(id, generationTime, (OutputStream)new ParallelGZIPOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(initRdGz), 262144)));
                        this.printHeapUsage();
                        LOGGER.trace("Start Virtual");
                        virtual = new File(generatorDir, id + ".virtual");
                        this.bootableDiskImageBuilder.build(virtual, (InputStream)new BufferedInputStream(new FileInputStream(initRdGz), 262144), initRdGz.length());
                        virtualGz = new File(generatorDir, id + ".virtual.gz");
                        IOUtils.copy((File)virtual, (OutputStream)new ParallelGZIPOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(virtualGz), 262144)));
                        this.printHeapUsage();
                        LOGGER.trace("Start Signature");
                        byte[] metadataBytes = this.toMetadataBytes(id, generationTime);
                        byte[] signature = this.createSignature(metadataBytes, new BufferedInputStream(new FileInputStream(virtual), 262144));
                        this.printHeapUsage();
                        LOGGER.trace("Start Image");
                        new ImageBuilder().build(id, metadataBytes, new BufferedInputStream(new FileInputStream(virtualGz), 262144), virtualGz.length(), ChecksumUtils.crc32((InputStream)new FileInputStream(virtualGz)), signature, this.repository.prepare(id));
                    }
                    catch (Throwable throwable) {
                        ShellUtils.deleteFile(initRdGz);
                        ShellUtils.deleteFile(virtual);
                        ShellUtils.deleteFile(virtualGz);
                        throw throwable;
                    }
                    ShellUtils.deleteFile((File)initRdGz);
                    ShellUtils.deleteFile((File)virtual);
                    ShellUtils.deleteFile((File)virtualGz);
                    break block8;
                }
                LOGGER.trace("Start RAM");
                ByteArrayOutputStream ramDisk = new ByteArrayOutputStream(0x1400000);
                this.ramDiskBuilder.build(id, generationTime, (OutputStream)new ParallelGZIPOutputStream((OutputStream)ramDisk));
                this.printHeapUsage();
                LOGGER.trace("Start Virtual");
                byte[] virtualDisk = this.bootableDiskImageBuilder.build((InputStream)new ByteArrayInputStream(ramDisk.toByteArray()), (long)ramDisk.size());
                this.printHeapUsage();
                LOGGER.trace("Start Signature");
                byte[] metadataBytes = this.toMetadataBytes(id, generationTime);
                byte[] signature = this.createSignature(metadataBytes, new ByteArrayInputStream(virtualDisk));
                this.printHeapUsage();
                LOGGER.trace("Start Image");
                ByteArrayOutputStream compressed = new ByteArrayOutputStream();
                IOUtils.copy((byte[])virtualDisk, (OutputStream)new ParallelGZIPOutputStream((OutputStream)compressed));
                byte[] compressedBytes = compressed.toByteArray();
                new ImageBuilder().build(id, metadataBytes, new ByteArrayInputStream(compressedBytes), compressedBytes.length, ChecksumUtils.crc32((byte[])compressedBytes), signature, this.repository.prepare(id));
            }
            this.printHeapUsage();
            this.repository.refresh();
            Image image = this.repository.get(id);
            stopWatch.stop();
            LOGGER.info("Image fused in " + TimeFormat.format((long)stopWatch.getTotalTimeMillis()) + " (" + image.getSize() / 1024L + " K) -> " + image);
            Image image2 = image;
            return image2;
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to fuse image: " + e.getMessage(), (Throwable)e);
        }
        finally {
            busyIndicator.stop();
        }
    }

    private void printHeapUsage() {
        System.gc();
        long totalMem = Runtime.getRuntime().totalMemory();
        long usedMem = totalMem - Runtime.getRuntime().freeMemory();
        LOGGER.trace("Heap usage: " + usedMem / 0x100000L + " of " + totalMem / 0x100000L + "M");
    }

    private byte[] toMetadataBytes(String id, Date generationTime) {
        this.metadata.version = this.spec.getCoordinates().getVersion();
        this.metadata.database.type = this.spec.getDbType() == null ? DbType.NONE : this.spec.getDbType();
        this.metadata.id = id;
        this.metadata.generated.utc = generationTime;
        this.metadata.size = this.bootableDiskImageBuilder.getDiskSize();
        ByteArrayOutputStream metadataBytes = new ByteArrayOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            objectMapper.writeValue((OutputStream)metadataBytes, (Object)this.metadata);
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to create Image metadata", (Throwable)e);
        }
        return metadataBytes.toByteArray();
    }

    private byte[] createSignature(byte[] metadata, InputStream virtualDisk) {
        try {
            int bytesRead;
            Signature signature = Signature.getInstance("SHA512withRSA");
            signature.initSign(this.privateKey);
            signature.update(metadata);
            byte[] buffer = new byte[8192];
            while ((bytesRead = virtualDisk.read(buffer)) != -1) {
                signature.update(buffer, 0, bytesRead);
            }
            return signature.sign();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BoxfuseBugException("Unable to sign Image", (Throwable)e);
        }
    }

    public Collection<Component> getComponents() {
        return this.ramDiskBuilder.getComponents();
    }

    static ImageMetadata toImageMetadata(ImageSpec spec, Collection<Component> components) {
        ImageMetadata metadata = new ImageMetadata();
        metadata.owner = spec.getCoordinates().getOwner();
        metadata.name = spec.getCoordinates().getName();
        if (spec.getCoordinates().getVersion() != null) {
            metadata.version = spec.getCoordinates().getVersion();
        }
        metadata.generated.boxfuse = BoxfuseConfig.VERSION;
        metadata.payload.name = spec.getPayload().getName();
        metadata.payload.file = spec.isLive() ? spec.getPayload().getFile().getAbsolutePath() : null;
        metadata.payload.type = spec.getPayload().getType();
        metadata.payload.checksum = spec.getPayload().getChecksum();
        metadata.payload.port = spec.getPayloadPort();
        metadata.payload.path = spec.getPayloadPath();
        metadata.live = spec.isLive();
        metadata.database.type = spec.getDbType();
        metadata.logs.type = spec.getLogsType() == null ? LogsType.NONE : spec.getLogsType();
        metadata.platforms = Arrays.asList(spec.getPlatforms());
        metadata.ports = new TreeMap();
        for (PortName portName : spec.getPorts().keySet()) {
            ImageMetadata.PortMetadata portMetadata = new ImageMetadata.PortMetadata();
            Port port = spec.getPorts().get(portName);
            portMetadata.number = port.getNumber();
            portMetadata.protocol = port.getProtocol();
            portMetadata.restriction = port.getRestriction();
            metadata.ports.put(portName, portMetadata);
        }
        metadata.healthcheck.enabled = spec.isHealthcheck();
        metadata.healthcheck.port = spec.getHealthcheckPort();
        metadata.healthcheck.path = spec.getHealthcheckPath();
        metadata.healthcheck.timeout = spec.getHealthcheckTimeout();
        metadata.debug.enabled = spec.isDebug();
        metadata.debug.wait = spec.isDebugWait();
        metadata.strace.enabled = spec.isStrace();
        metadata.tmp = spec.getTmp();
        metadata.components = new TreeMap();
        for (Component component : components) {
            metadata.components.put(component.getId(), component.getVersion());
        }
        metadata.linux.args = spec.getLinuxArgs();
        metadata.jvm.args = spec.getJvm().getJvmArgs();
        metadata.jvm.mainClass = spec.getJvm().getMainClass();
        metadata.jvm.mainArgs = spec.getJvm().getMainArgs();
        metadata.jvm.jmx.enabled = spec.getJvm().isJmx();
        return metadata;
    }

    private RamDiskBuilder createRamDiskBuilder(Collection<Component> virtualDiskComponents) {
        switch (this.spec.getPayload().getType()) {
            case JAR: {
                return new JarRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case DROPWIZARD: {
                return new DropwizardRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case GRAILS: 
            case JHIPSTER: 
            case SPRINGBOOT: {
                return new SpringBootRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case TOMCAT: {
                return new TomcatRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case TOMEE: {
                return new TomeeRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case PLAY: {
                return new PlayRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case NODEJS: {
                return new NodeJsRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case LINUX_X64: {
                return new GenericRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
            case REVEL: {
                return new RevelRamDiskBuilder(this.certificateManager, this.inventory, this.spec, virtualDiskComponents);
            }
        }
        throw new BoxfuseBugException("Unable to fuse Image for unknown Payload type: " + this.spec.getPayload().getType());
    }
}

