/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk;

import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.ramdisk.RamDiskEntryType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamDisk {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamDisk.class);
    private static final short CPIO_FORMAT = 1;
    private static final int READ_PERMISSION = 256;
    private static final int EXECUTE_PERMISSION = 64;
    private static final List<String> skippedDirectories = Arrays.asList(".git", ".idea", ".gradle");
    private final CpioArchiveOutputStream cpio;
    public static final String LIVE_MOUNT = "/live";
    private final Date generationTime;
    private Map<String, RamDiskEntryType> entries = new HashMap<String, RamDiskEntryType>();

    public RamDisk(OutputStream outputStream, Date generationTime) {
        this.cpio = new CpioArchiveOutputStream(outputStream, 1);
        this.generationTime = generationTime;
    }

    public final void installTarGzArchive(byte[] tar, String baseRamDiskDir) throws IOException {
        this.installTarGzArchive(tar, baseRamDiskDir, "");
    }

    public final void installTarGzArchive(byte[] tar, String baseRamDiskDir, String baseArchiveDir) throws IOException {
        this.installTarGzArchive(tar, baseRamDiskDir, baseArchiveDir, false);
    }

    public final void installTarGzArchive(byte[] tar, String baseRamDiskDir, String baseArchiveDir, boolean executable) throws IOException {
        this.installTarArchive(baseRamDiskDir, baseArchiveDir, null, executable, new GZIPInputStream(new ByteArrayInputStream(tar)));
    }

    public final void installTarXzArchive(byte[] tar, String baseRamDiskDir, String baseArchiveDir, String includeRegex) throws IOException {
        this.installTarArchive(baseRamDiskDir, baseArchiveDir, includeRegex, false, (InputStream)new XZCompressorInputStream((InputStream)new ByteArrayInputStream(tar)));
    }

    private void installTarArchive(String baseRamDiskDir, String baseArchiveDir, String includeRegex, boolean executable, InputStream inputStream) throws IOException {
        TarArchiveEntry entry;
        baseRamDiskDir = this.normalizeName(baseRamDiskDir);
        baseArchiveDir = !StringUtils.hasLength((String)(baseArchiveDir = this.normalizeName(baseArchiveDir))) ? "" : baseArchiveDir + "/";
        TarArchiveInputStream tarStream = new TarArchiveInputStream(inputStream);
        while ((entry = (TarArchiveEntry)tarStream.getNextEntry()) != null) {
            String name = entry.getName();
            if (StringUtils.hasLength((String)baseArchiveDir) && !name.startsWith(baseArchiveDir)) continue;
            name = name.replace("\\", "/");
            name = name.substring(baseArchiveDir.length());
            if (includeRegex != null && !name.matches(includeRegex)) continue;
            if (entry.isDirectory()) {
                this.createDir(baseRamDiskDir + "/" + name);
                continue;
            }
            if (entry.isSymbolicLink()) {
                this.createSymLink(baseRamDiskDir + "/" + name, entry.getLinkName());
                continue;
            }
            boolean execute = (entry.getMode() & 1) != 0 || executable;
            this.createFile(baseRamDiskDir + "/" + name, execute, IOUtils.copyToByteArrayNoClose((InputStream)tarStream, (int)((int)entry.getSize())));
        }
        tarStream.close();
    }

    public void installZipArchive(byte[] archive, String baseRamDiskDir) throws IOException {
        this.installZipArchive(archive, baseRamDiskDir, null);
    }

    public final void installZipArchive(byte[] archive, String baseRamDiskDir, String baseArchiveDir) throws IOException {
        this.installZipArchive(archive, baseRamDiskDir, baseArchiveDir, false);
    }

    public final void installZipArchive(byte[] archive, String baseRamDiskDir, String baseArchiveDir, boolean executable) throws IOException {
        this.installZipArchive(archive, baseRamDiskDir, baseArchiveDir, null, executable, null);
    }

    public final void installZipArchive(byte[] archive, String baseRamDiskDir, String baseArchiveDir, String includeRegex, boolean executable, String nonExecutableRegex) throws IOException {
        baseRamDiskDir = this.normalizeName(baseRamDiskDir);
        baseArchiveDir = !StringUtils.hasLength((String)(baseArchiveDir = this.normalizeName(baseArchiveDir))) ? "" : baseArchiveDir + "/";
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream(archive));){
            ZipArchiveEntry entry;
            while ((entry = (ZipArchiveEntry)zip.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (StringUtils.hasLength((String)baseArchiveDir) && !entryName.startsWith(baseArchiveDir)) continue;
                entryName = entryName.substring(baseArchiveDir.length());
                if (entry.isDirectory() || includeRegex != null && !entryName.matches(includeRegex)) continue;
                boolean isExecutable = executable && (nonExecutableRegex == null || !entryName.matches(nonExecutableRegex));
                int size = (int)entry.getSize();
                byte[] contents = size < 0 ? IOUtils.copyToByteArrayNoClose((InputStream)zip) : IOUtils.copyToByteArrayNoClose((InputStream)zip, (int)size);
                this.createFile(baseRamDiskDir + "/" + entryName, isExecutable, contents);
            }
        }
    }

    public final void installDirectory(File dir, String baseDir) throws IOException {
        this.installDirectory(dir, baseDir, false);
    }

    public final void installDirectory(File dir, String baseDir, boolean forceExecutable) throws IOException {
        this.installDirectory(dir, baseDir, forceExecutable, null);
    }

    public final void installDirectory(File dir, String baseDir, boolean forceExecutable, String noExecutableRegex) throws IOException {
        baseDir = this.normalizeName(baseDir);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = baseDir + "/" + file.getName();
            if (file.isDirectory()) {
                if (skippedDirectories.contains(file.getName())) continue;
                this.installDirectory(file, name, forceExecutable);
                continue;
            }
            if (file.canRead()) {
                boolean executable = !(noExecutableRegex != null && file.getName().matches(noExecutableRegex) || !forceExecutable && !file.canExecute());
                this.createFile(name, executable, IOUtils.copyToByteArray((InputStream)new FileInputStream(file)));
                continue;
            }
            LOGGER.warn("Unable to read " + file.getAbsolutePath());
        }
    }

    public final void createDir(String name) throws IOException {
        if (this.entries.containsKey(name = this.normalizeName(name))) {
            return;
        }
        if (name.contains("/")) {
            this.createDir(name.substring(0, name.lastIndexOf("/")));
        }
        this.addEntry(RamDiskEntryType.DIRECTORY, name);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, name);
        entry.setMode(16704L);
        entry.setTime(this.generationTime.getTime());
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        this.cpio.closeArchiveEntry();
    }

    private void addEntry(RamDiskEntryType type, String name) {
        this.addEntry(type, name, false);
    }

    private void addEntry(RamDiskEntryType type, String name, String destination) {
        this.addEntry(type, name, destination, false);
    }

    private void addEntry(RamDiskEntryType type, String name, boolean executable) {
        this.addEntry(type, name, null, executable);
    }

    private void addEntry(RamDiskEntryType type, String name, String destination, boolean executable) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding " + type.name() + ": " + name + (destination == null ? "" : " -> " + destination) + (executable ? " +x" : ""));
        }
        this.entries.put(name, type);
    }

    public final void createFile(String name, boolean executable, String contents) throws IOException {
        this.createFile(name, executable, contents.getBytes(StandardCharsets.UTF_8));
    }

    public final void createFile(String name, boolean executable, byte[] contents) throws IOException {
        if (this.entries.containsKey(name = this.normalizeName(name))) {
            return;
        }
        if (name.contains("/")) {
            this.createDir(name.substring(0, name.lastIndexOf("/")));
        }
        if (contents == null) {
            contents = new byte[]{};
        }
        this.addEntry(RamDiskEntryType.FILE, name, executable);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, name);
        int mode = 33024;
        if (executable) {
            mode |= 0x40;
        }
        entry.setMode((long)mode);
        entry.setSize((long)contents.length);
        entry.setTime(this.generationTime.getTime());
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        this.cpio.write(contents);
        this.cpio.closeArchiveEntry();
    }

    public final void createSymLink(String name, String destination) throws IOException {
        if (this.entries.containsKey(name = this.normalizeName(name))) {
            return;
        }
        if (name.contains("/")) {
            this.createDir(name.substring(0, name.lastIndexOf("/")));
        }
        this.addEntry(RamDiskEntryType.SYMLINK, name, destination);
        byte[] contents = destination.getBytes(StandardCharsets.UTF_8);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, name);
        entry.setMode(40960L);
        entry.setSize((long)contents.length);
        entry.setTime(this.generationTime.getTime());
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        this.cpio.write(contents);
        this.cpio.closeArchiveEntry();
    }

    void createBlockDevice(String name, int major, int minor) throws IOException {
        if (this.entries.containsKey(name = this.normalizeName(name))) {
            return;
        }
        if (name.contains("/")) {
            this.createDir(name.substring(0, name.lastIndexOf("/")));
        }
        this.addEntry(RamDiskEntryType.BLOCK_DEVICE, name);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, name);
        entry.setMode(24832L);
        entry.setRemoteDeviceMaj((long)major);
        entry.setRemoteDeviceMin((long)minor);
        entry.setTime(this.generationTime.getTime());
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        this.cpio.closeArchiveEntry();
    }

    void createCharacterDevice(String name, int major, int minor) throws IOException {
        if (this.entries.containsKey(name = this.normalizeName(name))) {
            return;
        }
        if (name.contains("/")) {
            this.createDir(name.substring(0, name.lastIndexOf("/")));
        }
        this.addEntry(RamDiskEntryType.CHARACTER_DEVICE, name);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, name);
        entry.setMode(8448L);
        entry.setRemoteDeviceMaj((long)major);
        entry.setRemoteDeviceMin((long)minor);
        entry.setTime(this.generationTime.getTime());
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        this.cpio.closeArchiveEntry();
    }

    private String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

