/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.ManifestUtils;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarJarPayload
extends FilePayload
implements JarPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarJarPayload.class);
    private Boolean customJRE;
    protected String classesDir = "";

    public static boolean supports(String name, PayloadFormat format, boolean live) {
        return name.endsWith(".jar") && PayloadFormat.ZIP == format && !live;
    }

    public JarJarPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.JAR;
    }

    @Override
    public Collection<String> getJavaAgents() {
        ArrayList<String> javaAgents = new ArrayList<String>();
        for (String entry : this.entries.keySet()) {
            String javaagentsArchiveRoot;
            if (!entry.startsWith(javaagentsArchiveRoot = this.getJavaAgentsArchiveBaseDir() + "/")) continue;
            LOGGER.debug("Extracting Java Agent file: " + entry);
            String javaAgentEntryRelative = entry.substring(javaagentsArchiveRoot.length());
            if (!entry.endsWith(".jar") || javaAgentEntryRelative.contains("/")) continue;
            LOGGER.debug("Registering Java Agent: " + javaAgentEntryRelative);
            javaAgents.add("/javaagents/" + javaAgentEntryRelative);
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        String config = ZipUtils.unzipSingleEntry((byte[])this.bytes, (String)(this.classesDir + "newrelic.yml"));
        if (config == null) {
            return null;
        }
        return new NewRelicConfig(config);
    }

    @Override
    public boolean hasCustomJRE() {
        if (this.customJRE == null) {
            this.customJRE = this.entries.keySet().contains(this.classesDir + "jre/bin/java");
        }
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)(this.classesDir + "cacerts"));
        if (cacerts == null && this.hasCustomJRE()) {
            cacerts = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)(this.classesDir + "jre/lib/security/cacerts"));
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)(this.classesDir + "local_policy.jar"));
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)(this.classesDir + "US_export_policy.jar"));
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || !this.entries.containsKey(dbType.getJdbcDriverClass().replace(".", "/") + ".class")) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        return Pair.of(null, (Object)ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)(this.classesDir + "sysctl.conf")));
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.createFile(baseDir + "/" + this.name, false, this.bytes);
        ramDisk.installZipArchive(this.bytes, "javaagents", this.getJavaAgentsArchiveBaseDir(), false);
    }

    @Override
    public byte[] getManifest() {
        return ManifestUtils.extractManifest(this.bytes);
    }

    @Override
    public String getClassPath() {
        return "/app/" + this.name;
    }

    @Override
    public void installCustomJREInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installZipArchive(this.bytes, baseDir, this.classesDir + "jre/", null, true, ".*/" + Pattern.quote("jmxremote.password"));
    }

    @Override
    public void installNativeBinariesAndLibsInto(RamDisk ramDisk, String nativeDirectory) throws IOException {
        ramDisk.installZipArchive(this.bytes, nativeDirectory, this.classesDir + "native/", true);
    }

    private String getJavaAgentsArchiveBaseDir() {
        return this.classesDir + "javaagents";
    }
}

