/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar;

import com.boxfuse.base.util.ZipUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestUtils {
    private ManifestUtils() {
    }

    public static byte[] extractManifest(byte[] bytes) {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])bytes, (String)"META-INF/MANIFEST.MF");
    }

    public static String getMainClass(byte[] manifestBytes) {
        return ManifestUtils.getAttributeFromJarManifest(manifestBytes, Attributes.Name.MAIN_CLASS.toString());
    }

    public static String getImplementationTitle(byte[] manifestBytes) {
        return ManifestUtils.getAttributeFromJarManifest(manifestBytes, Attributes.Name.IMPLEMENTATION_TITLE.toString());
    }

    public static String getAttributeFromJarManifest(byte[] manifestBytes, String attributeName) {
        if (manifestBytes == null) {
            return null;
        }
        try {
            return new Manifest(new ByteArrayInputStream(manifestBytes)).getMainAttributes().getValue(attributeName);
        }
        catch (IOException e) {
            return null;
        }
    }
}

