/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard;

import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarDirectoyPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DropwizardDirectoryPayload
extends JarDirectoyPayload
implements DropwizardPayload {
    public static boolean supports(PayloadFormat format, List<String> entries) {
        return PayloadFormat.DIRECTORY == format && entries.contains("META-INF/services/io.dropwizard.server.ServerFactory");
    }

    public DropwizardDirectoryPayload(File file, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(file, payloadSize, entries, live);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.DROPWIZARD;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        super.installInto(ramDisk, baseDir);
        for (String entry : this.entries.keySet()) {
            if (entry.contains("/") || !entry.endsWith(".yml") && !entry.endsWith(".jks") && !entry.endsWith(".keystore")) continue;
            byte[] entryBytes = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + entry));
            ramDisk.createFile("app/" + entry, false, entryBytes);
        }
    }

    @Override
    public byte[] getBoxfuseYml() {
        return IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/boxfuse.yml"));
    }
}

