/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.play;

import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.Path;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigResolveOptions;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayConfig.class);
    private static final String PLAY_SERVER_HTTP_PORT = "play.server.http.port";
    private static final String PLAY_SERVER_HTTPS_PORT = "play.server.https.port";
    private final boolean empty;
    private final Map<PortName, Port> ports = new HashMap<PortName, Port>();
    private final Path payloadPath;

    PlayConfig(TlsType tlsType, String hocon) {
        String val;
        Config conf;
        try {
            conf = ConfigFactory.parseString((String)hocon).resolve(ConfigResolveOptions.noSystem().setAllowUnresolved(true));
        }
        catch (ConfigException e) {
            throw new BoxfuseException("Invalid Play configuration: " + e.getMessage());
        }
        this.empty = conf.entrySet().isEmpty();
        String context = this.hasPath(conf, "application.context") ? conf.getString("application.context") : "/";
        context = this.hasPath(conf, "play.http.context") ? conf.getString("play.http.context") : context;
        this.payloadPath = Path.of((String)(context.startsWith("/") ? context : "/" + context));
        if (this.hasPath(conf, PLAY_SERVER_HTTP_PORT) && !"disabled".equals(val = conf.getString(PLAY_SERVER_HTTP_PORT))) {
            try {
                this.ports.put(PortName.HTTP, Port.of((String)(conf.getInt(PLAY_SERVER_HTTP_PORT) + "/http")));
            }
            catch (Exception e) {
                LOGGER.warn("Invalid port definition in application.conf (play.server.http.port=" + val + "): " + e.getMessage());
            }
        }
        if (this.hasPath(conf, PLAY_SERVER_HTTPS_PORT)) {
            try {
                this.ports.put(PortName.HTTPS, Port.of((String)(conf.getInt(PLAY_SERVER_HTTPS_PORT) + "/https")));
            }
            catch (Exception e) {
                LOGGER.warn("Invalid port definition in application.conf (play.server.https.port=" + conf.getString(PLAY_SERVER_HTTPS_PORT) + "): " + e.getMessage());
            }
        }
        if (this.ports.isEmpty()) {
            if (tlsType == TlsType.ACM) {
                this.ports.put(PortName.HTTPS, Port.of((String)"443/https"));
            } else {
                this.ports.put(PortName.HTTP, Port.of((String)"9000/http"));
            }
        }
    }

    private boolean hasPath(Config conf, String key) {
        try {
            return conf.hasPath(key);
        }
        catch (ConfigException.NotResolved e) {
            LOGGER.warn("Ignoring unresolved value for " + key + " in application.conf => replace placeholder with concrete value");
            return false;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Map<PortName, Port> getPorts() {
        return this.ports;
    }

    public Path getPayloadPath() {
        return this.payloadPath;
    }
}

