/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.image;

import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.metadata.ImageMetadata;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.image.AbstractJvmSpec;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.image.spec.ImageSpec;
import com.boxfuse.generator.image.spec.JvmSpec;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.payload.MetadataPayload;
import com.boxfuse.generator.payload.Payload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class MetadataImage
implements Image {
    private final ImageMetadata metadata;

    public MetadataImage(ImageMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public ImageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getId() {
        return this.metadata.id;
    }

    @Override
    public Version getBoxfuseVersion() {
        return this.metadata.generated.boxfuse;
    }

    @Override
    public ImageCoordinates getCoordinates() {
        return new ImageCoordinates(this.metadata.owner, this.metadata.name, this.metadata.version);
    }

    @Override
    public PlatformType[] getPlatforms() {
        return this.metadata.platforms.toArray(new PlatformType[this.metadata.platforms.size()]);
    }

    @Override
    public boolean isLive() {
        return this.metadata.live;
    }

    @Override
    public Payload getPayload() {
        return new MetadataPayload(this.metadata.payload);
    }

    @Override
    public Path getPayloadPath() {
        return this.metadata.payload.path;
    }

    @Override
    public PortName getPayloadPort() {
        return this.metadata.payload.port;
    }

    @Override
    public AppType getAppType() {
        return this.metadata.app.type;
    }

    @Override
    public DbType getDbType() {
        return this.metadata.database.type;
    }

    @Override
    public LogsType getLogsType() {
        return this.metadata.logs.type;
    }

    @Override
    public Map<PortName, Port> getPorts() {
        TreeMap<PortName, Port> result = new TreeMap<PortName, Port>();
        for (PortName port : this.metadata.ports.keySet()) {
            ImageMetadata.PortMetadata portMetadata = (ImageMetadata.PortMetadata)this.metadata.ports.get(port);
            result.put(port, Port.of((int)portMetadata.number, (Protocol)portMetadata.protocol, (Restriction)portMetadata.restriction));
        }
        return result;
    }

    @Override
    public boolean isHealthcheck() {
        return this.metadata.healthcheck.enabled;
    }

    @Override
    public Path getHealthcheckPath() {
        return this.metadata.healthcheck.path;
    }

    @Override
    public PortName getHealthcheckPort() {
        return this.metadata.healthcheck.port;
    }

    @Override
    public HealthcheckTimeout getHealthcheckTimeout() {
        return this.metadata.healthcheck.timeout;
    }

    @Override
    public boolean isDebug() {
        return this.metadata.debug.enabled;
    }

    @Override
    public boolean isDebugWait() {
        return this.metadata.debug.wait;
    }

    @Override
    public boolean isStrace() {
        return this.metadata.strace.enabled;
    }

    @Override
    public InputStream getDiskImage() {
        return null;
    }

    @Override
    public byte[] getSignature() {
        return null;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public long getSize() {
        return this.metadata.size;
    }

    @Override
    public Date getGeneratedUtc() {
        return this.metadata.generated.utc;
    }

    @Override
    public Map<ComponentId, Version> getComponents() {
        return this.metadata.components;
    }

    @Override
    public String getLinuxArgs() {
        return this.metadata.linux.args;
    }

    @Override
    public JvmSpec getJvm() {
        return new AbstractJvmSpec(){

            @Override
            public String getJvmArgs() {
                return ((MetadataImage)MetadataImage.this).metadata.jvm.args;
            }

            @Override
            public String getMainClass() {
                return ((MetadataImage)MetadataImage.this).metadata.jvm.mainClass;
            }

            @Override
            public String getMainArgs() {
                return ((MetadataImage)MetadataImage.this).metadata.jvm.mainArgs;
            }

            @Override
            public boolean isJmx() {
                return ((MetadataImage)MetadataImage.this).metadata.jvm.jmx.enabled;
            }
        };
    }

    @Override
    public TmpGB getTmp() {
        return this.metadata.tmp;
    }

    @Override
    public Map<String, Object> getManifest() {
        try {
            return JsonUtils.jsonToMap((String)new ObjectMapper().writeValueAsString((Object)this.metadata));
        }
        catch (JsonProcessingException e) {
            throw new BoxfuseException("Unable to read manifest of Image: " + this.getId(), (Throwable)e);
        }
    }

    @Override
    public void rm() {
    }

    @Override
    public boolean matches(String owner, ImageSpec spec, List<Component> components) {
        TreeMap<ComponentId, Version> c = new TreeMap<ComponentId, Version>();
        for (Component component : components) {
            c.put(component.getId(), component.getVersion());
        }
        return this.getPayload().equals(spec.getPayload()) && (BoxfuseConfig.VERSION.getVersion().startsWith("00") || BoxfuseConfig.VERSION.equals((Object)this.getBoxfuseVersion())) && Objects.equals(this.getCoordinates(), spec.getCoordinates()) && this.getDbType() == spec.getDbType() && this.isDebug() == spec.isDebug() && this.isDebugWait() == spec.isDebugWait() && this.isStrace() == spec.isStrace() && this.getPorts().equals(spec.getPorts()) && this.getHealthcheckPath().equals((Object)spec.getHealthcheckPath()) && this.getComponents().equals(c) && this.getJvm().equals(spec.getJvm()) && this.isLive() == spec.isLive();
    }

    @Override
    public int compareTo(Image o) {
        return this.getCoordinates().compareTo(o.getCoordinates());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataImage that = (MetadataImage)o;
        return this.metadata.equals((Object)that.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return this.getCoordinates().toString();
    }
}

