/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.image.spec;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.image.spec.ImageSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ImageSpecValidator {
    private static final List<Protocol> HEALTHCHECK_PROTOCOLS = Arrays.asList(Protocol.HTTP, Protocol.HTTPS);
    private final ImageSpec spec;

    public ImageSpecValidator(ImageSpec spec) {
        this.spec = spec;
    }

    public void validateHealthcheckPort(PortName healthcheckPort) {
        Map<PortName, Port> ports = this.spec.getPorts();
        if (!ports.containsKey(healthcheckPort)) {
            throw new BoxfuseException("Unknown healthcheck port: " + healthcheckPort + " (Should be one of: " + StringUtils.collectionToDelimitedString(ports.keySet(), (String)", ") + ")");
        }
        Protocol protocol = ports.get(healthcheckPort).getProtocol();
        if (!HEALTHCHECK_PROTOCOLS.contains(protocol)) {
            throw new BoxfuseException("Unsupported protocol for healthcheck port \"" + healthcheckPort + "\": " + protocol + " (Should be one of: " + StringUtils.collectionToDelimitedString(HEALTHCHECK_PROTOCOLS, (String)", ") + ")");
        }
    }
}

