/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.inventory;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class Component
implements Comparable<Component> {
    private final ComponentId id;
    private final Version version;
    private final File file;
    private final byte[] checksum;

    public Component(ComponentId id, Version version, File file) {
        this.id = id;
        this.version = version;
        this.file = file;
        try {
            this.checksum = DigestUtils.md5((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to calculate checksum for " + id + " " + version, (Throwable)e);
        }
    }

    public ComponentId getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public byte[] getBytes() {
        return IOUtils.copyToByteArray((File)this.file);
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return this.id.getId() + ':' + this.version;
    }

    @Override
    public int compareTo(Component o) {
        if (!this.id.equals((Object)o.id)) {
            return this.id.compareTo((Enum)o.id);
        }
        if (!this.version.equals((Object)o.version)) {
            return this.version.compareTo(o.version);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component component = (Component)o;
        return this.id == component.id && this.version.equals((Object)component.version);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public File getFile() {
        return this.file;
    }
}

