/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.env;

import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.util.ByteArrayUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class EnvironmentScript {
    private final String script;

    public EnvironmentScript(Map<EnvVarName, EnvVarValue> environment) {
        StringBuilder scriptBuilder = new StringBuilder();
        for (EnvVarName key : environment.keySet()) {
            if (!key.getName().startsWith("BOXFUSE_")) continue;
            this.appendExport(scriptBuilder, key, environment.get(key));
        }
        for (EnvVarName key : environment.keySet()) {
            if (key.getName().startsWith("BOXFUSE_")) continue;
            this.appendExport(scriptBuilder, key, environment.get(key));
        }
        this.script = scriptBuilder.toString();
    }

    private void appendExport(StringBuilder scriptBuilder, EnvVarName key, EnvVarValue val) {
        if (val != null) {
            if (val.isAsIs()) {
                String value = val.getValue().replace("'", "'\"'\"'");
                scriptBuilder.append("export ").append(key).append("='").append(value).append("'\n");
            } else if (val.getValue().matches("\\$[A-Z_][A-Z0-9_]+")) {
                scriptBuilder.append("export ").append(key).append("=").append(val.getValue()).append("\n");
            } else {
                String value = val.getValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("`", "\\`").replace("$", "\\$");
                scriptBuilder.append("export ").append(key).append("=\"").append(value).append("\"\n");
            }
        }
    }

    public String getScript() {
        return this.script;
    }

    public byte[] getScriptAsBytes() {
        return this.script.getBytes(StandardCharsets.UTF_8);
    }

    public String getScriptAsBase64() {
        return ByteArrayUtils.toBase64(this.getScriptAsBytes());
    }
}

