/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.tar;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsPath;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006BO\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\u000f\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000f\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/boxfuse/base/fsimage/tar/TarFsFile;", "Lcom/boxfuse/base/fsimage/FsFile;", "tarEntry", "Lorg/apache/commons/compress/archivers/tar/TarArchiveEntry;", "data", "", "(Lorg/apache/commons/compress/archivers/tar/TarArchiveEntry;[B)V", "path", "Lcom/boxfuse/base/fsimage/FsPath;", "type", "Lcom/boxfuse/base/fsimage/FsFileType;", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "size", "", "destination", "", "major", "", "minor", "(Lcom/boxfuse/base/fsimage/FsPath;Lcom/boxfuse/base/fsimage/FsFileType;Lcom/boxfuse/base/fsimage/FsFileMode;JLjava/lang/String;Ljava/lang/Byte;Ljava/lang/Byte;[B)V", "Ljava/lang/Byte;", "getData", "Ljava/io/InputStream;", "getDestination", "getMajor", "()Ljava/lang/Byte;", "getMinor", "getMode", "getPath", "getSize", "getType", "Companion", "boxfuse-base-fsimage"})
public final class TarFsFile
implements FsFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FsPath path;
    @NotNull
    private final FsFileType type;
    @NotNull
    private final FsFileMode mode;
    private final long size;
    @Nullable
    private final String destination;
    @Nullable
    private final Byte major;
    @Nullable
    private final Byte minor;
    @Nullable
    private final byte[] data;
    private static final int RUSR = 256;
    private static final int WUSR = 128;
    private static final int XUSR = 64;
    private static final int RGRP = 32;
    private static final int WGRP = 16;
    private static final int XGRP = 8;
    private static final int ROTH = 4;
    private static final int WOTH = 2;
    private static final int XOTH = 1;

    public TarFsFile(@NotNull FsPath path, @NotNull FsFileType type, @NotNull FsFileMode mode, long size, @Nullable String destination, @Nullable Byte major, @Nullable Byte minor, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(mode, "mode");
        this.path = path;
        this.type = type;
        this.mode = mode;
        this.size = size;
        this.destination = destination;
        this.major = major;
        this.minor = minor;
        this.data = data;
        FsFileType[] fsFileTypeArray = new FsFileType[]{FsFileType.BLOCK_DEVICE, FsFileType.CHARACTER_DEVICE};
        boolean bl = !CollectionsKt.listOf(fsFileTypeArray).contains((Object)this.type) || this.major != null && this.minor != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Only device files must have major and minor number";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.type != FsFileType.SYMBOLIC_LINK || this.destination != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Only symbolic links must have a destination";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.type == FsFileType.REGULAR_FILE || this.data == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Only regular files may have data";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public TarFsFile(@NotNull TarArchiveEntry tarEntry, @Nullable byte[] data) {
        FsFileType fsFileType;
        Intrinsics.checkNotNullParameter(tarEntry, "tarEntry");
        String string = tarEntry.getName();
        Intrinsics.checkNotNullExpressionValue(string, "tarEntry.name");
        FsPath fsPath = Companion.fromTarPath$boxfuse_base_fsimage(string);
        if (tarEntry.isBlockDevice()) {
            fsFileType = FsFileType.BLOCK_DEVICE;
        } else if (tarEntry.isCharacterDevice()) {
            fsFileType = FsFileType.CHARACTER_DEVICE;
        } else if (tarEntry.isFIFO()) {
            fsFileType = FsFileType.FIFO;
        } else if (tarEntry.isSymbolicLink()) {
            fsFileType = FsFileType.SYMBOLIC_LINK;
        } else if (tarEntry.isDirectory()) {
            fsFileType = FsFileType.DIRECTORY;
        } else if (tarEntry.isFile()) {
            fsFileType = FsFileType.REGULAR_FILE;
        } else {
            throw new IllegalArgumentException("Unknown tar entry type");
        }
        this(fsPath, fsFileType, Companion.fromTarMode$boxfuse_base_fsimage(tarEntry.getMode()), tarEntry.getSize(), tarEntry.getLinkName(), tarEntry.isCharacterDevice() || tarEntry.isBlockDevice() ? Byte.valueOf((byte)tarEntry.getDevMajor()) : null, tarEntry.isCharacterDevice() || tarEntry.isBlockDevice() ? Byte.valueOf((byte)tarEntry.getDevMinor()) : null, (byte[])(tarEntry.isFile() ? data : null));
    }

    @Override
    @NotNull
    public FsPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public FsFileType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public FsFileMode getMode() {
        return this.mode;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public String getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public Byte getMajor() {
        return this.major;
    }

    @Override
    @Nullable
    public Byte getMinor() {
        return this.minor;
    }

    @Override
    @Nullable
    public InputStream getData() {
        ByteArrayInputStream byteArrayInputStream;
        byte[] byArray = this.data;
        if (byArray == null) {
            byteArrayInputStream = null;
        } else {
            byte[] byArray2 = byArray;
            boolean bl = false;
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
        }
        return byteArrayInputStream;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/boxfuse/base/fsimage/tar/TarFsFile$Companion;", "", "()V", "RGRP", "", "ROTH", "RUSR", "WGRP", "WOTH", "WUSR", "XGRP", "XOTH", "XUSR", "fromTarMode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "tarMode", "fromTarMode$boxfuse_base_fsimage", "fromTarPath", "Lcom/boxfuse/base/fsimage/FsPath;", "tarPath", "", "fromTarPath$boxfuse_base_fsimage", "toTarMode", "mode", "toTarMode$boxfuse_base_fsimage", "boxfuse-base-fsimage"})
    public static final class Companion {
        private Companion() {
        }

        public final int toTarMode$boxfuse_base_fsimage(@NotNull FsFileMode mode) {
            Intrinsics.checkNotNullParameter(mode, "mode");
            int tarMode = 0;
            if (mode.getRusr()) {
                tarMode |= 0x100;
            }
            if (mode.getWusr()) {
                tarMode |= 0x80;
            }
            if (mode.getXusr()) {
                tarMode |= 0x40;
            }
            if (mode.getRgrp()) {
                tarMode |= 0x20;
            }
            if (mode.getWgrp()) {
                tarMode |= 0x10;
            }
            if (mode.getXgrp()) {
                tarMode |= 8;
            }
            if (mode.getRoth()) {
                tarMode |= 4;
            }
            if (mode.getWoth()) {
                tarMode |= 2;
            }
            if (mode.getXoth()) {
                tarMode |= 1;
            }
            return tarMode;
        }

        @NotNull
        public final FsFileMode fromTarMode$boxfuse_base_fsimage(int tarMode) {
            return new FsFileMode(false, false, false, (tarMode & 0x100) == 256, (tarMode & 0x80) == 128, (tarMode & 0x40) == 64, (tarMode & 0x20) == 32, (tarMode & 0x10) == 16, (tarMode & 8) == 8, (tarMode & 4) == 4, (tarMode & 2) == 2, (tarMode & 1) == 1);
        }

        @NotNull
        public final FsPath fromTarPath$boxfuse_base_fsimage(@NotNull String tarPath) {
            String string;
            String path;
            String string2;
            int n;
            int n2;
            String string3;
            Intrinsics.checkNotNullParameter(tarPath, "tarPath");
            if (StringsKt.startsWith$default(tarPath, "./", false, 2, null)) {
                string3 = tarPath;
                n2 = 2;
                n = 0;
                String string4 = string3.substring(n2);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = path = tarPath;
            }
            if (Intrinsics.areEqual(path, "/")) {
                return new FsPath("/");
            }
            if (StringsKt.endsWith$default(path, "/", false, 2, null)) {
                string3 = path;
                n2 = 0;
                n = path.length() - 1;
                boolean bl = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, n);
                string = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = path;
            }
            path = string;
            return new FsPath(Intrinsics.stringPlus("/", path));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

