/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.ByteArrayUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public class MacAddress {
    private final byte[] mac;

    private MacAddress(byte[] mac) {
        this.mac = mac;
        if (mac.length != 6) {
            throw new BoxfuseException("Invalid MAC address bytes: [" + ByteArrayUtils.toHex(mac) + "]");
        }
    }

    public static MacAddress of(byte[] mac) {
        if (mac == null) {
            return null;
        }
        return new MacAddress(mac);
    }

    @JsonCreator
    public static MacAddress of(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        if (!macAddress.matches("^[A-Fa-f0-9]{2}[\\-:][A-Fa-f0-9]{2}[\\-:][A-Fa-f0-9]{2}[\\-:][A-Fa-f0-9]{2}[\\-:][A-Fa-f0-9]{2}[\\-:][A-Fa-f0-9]{2}$")) {
            throw new BoxfuseException("Invalid MAC address: " + macAddress);
        }
        return new MacAddress(ByteArrayUtils.fromHex(macAddress.replace("-", "").replace(":", "")));
    }

    public byte[] getBytes() {
        return this.mac;
    }

    @JsonValue
    public String getMacAddress() {
        String result = "";
        for (int i2 = 0; i2 < this.mac.length; ++i2) {
            result = result + ByteArrayUtils.toHex(this.mac[i2]);
            if (i2 >= this.mac.length - 1) continue;
            result = result + ":";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacAddress that = (MacAddress)o;
        return Arrays.equals(this.mac, that.mac);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mac);
    }

    public String toString() {
        return this.getMacAddress();
    }
}

