/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;

public class Proxy {
    private final String protocol;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final String url;

    public static Proxy of(String url) {
        if (url == null) {
            return null;
        }
        return new Proxy(url);
    }

    public Proxy(String url) {
        this.url = url;
        String error = "Invalid proxy url: " + url + " (must be in one of the following formats: http://host:port https://host:port http://user:pwd@host:port https://user:pwd@host:port)";
        int protocolEnd = url.indexOf("://");
        if (protocolEnd <= 0) {
            throw new BoxfuseException(error);
        }
        this.protocol = url.substring(0, protocolEnd);
        if (!"http".equals(this.protocol) && !"https".equals(this.protocol)) {
            throw new BoxfuseException(error);
        }
        int authEnd = url.indexOf("@");
        if (authEnd < 0) {
            this.user = null;
            this.password = null;
        } else {
            String authPart = url.substring(protocolEnd + 3, authEnd);
            if (!StringUtils.hasLength(authPart)) {
                throw new BoxfuseException(error);
            }
            int userEnd = authPart.indexOf(":");
            this.user = authPart.substring(0, userEnd);
            this.password = authPart.substring(userEnd + 1);
        }
        int hostStart = authEnd < 0 ? protocolEnd + 3 : authEnd + 1;
        String hostPart = url.substring(hostStart);
        int hostEnd = hostPart.indexOf(":");
        if (hostEnd < 0) {
            throw new BoxfuseException(error);
        }
        this.host = hostPart.substring(0, hostEnd);
        if (!StringUtils.hasLength(this.host)) {
            throw new BoxfuseException(error);
        }
        String portPart = hostPart.substring(hostEnd + 1);
        if (portPart.endsWith("/")) {
            portPart = hostPart.substring(0, portPart.length() - 1);
        }
        try {
            this.port = Integer.parseInt(portPart);
        }
        catch (NumberFormatException e) {
            throw new BoxfuseException(error);
        }
        if (this.port < 0 || this.port > 65535) {
            throw new BoxfuseException(error);
        }
    }

    public Proxy(String protocol, String host, int port, String user, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.url = protocol + "://" + (user == null ? "" : user + ":" + password + "@") + host + ":" + port;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

