/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseBugException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class ByteArrayUtils {
    private ByteArrayUtils() {
    }

    public static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i2 = 0; i2 < binary.length; ++i2) {
            binary[i2] = (byte)Integer.parseInt(hex.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return binary;
    }

    public static String toHex(byte ... array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public static byte[] fromBase64(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] fromInt(int i2) {
        return new byte[]{(byte)(i2 >> 24 & 0xFF), (byte)(i2 >> 16 & 0xFF), (byte)(i2 >> 8 & 0xFF), (byte)(i2 & 0xFF)};
    }

    public static int toInt(byte[] bytes) {
        return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static List<byte[]> split(byte[] source) {
        return ByteArrayUtils.split(source, 0xA00000);
    }

    public static List<byte[]> split(byte[] source, int size) {
        try {
            int tmp;
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            ByteArrayInputStream in = new ByteArrayInputStream(source);
            byte[] buffer = new byte[size];
            while ((tmp = in.read(buffer)) > 0) {
                ByteArrayOutputStream part = new ByteArrayOutputStream();
                part.write(buffer, 0, tmp);
                parts.add(part.toByteArray());
            }
            return parts;
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to split " + source.length + " bytes", e);
        }
    }
}

