/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String RANDOM_NUMBERS = "0123456789";
    private static final String RANDOM_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String RANDOM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final Random rnd = new Random();

    private StringUtils() {
    }

    public static String trimOrPad(Object str, int length) {
        return StringUtils.trimOrPad(str, length, ' ');
    }

    public static String trimOrPad(Object str, int length, char padChar) {
        String result = str == null ? "" : str.toString();
        if (result.length() > length) {
            return StringUtils.rightTrim(result, length);
        }
        while (result.length() < length) {
            result = result + padChar;
        }
        return result;
    }

    public static String leftTrimOrPad(Object str, int length) {
        return StringUtils.leftTrimOrPad(str, length, ' ');
    }

    public static String leftTrimOrPad(Object str, int length, char padChar) {
        String result = str == null ? "" : str.toString();
        if (result.length() > length) {
            return StringUtils.leftTrim(result, length);
        }
        StringBuilder resultBuilder = new StringBuilder(result);
        while (resultBuilder.length() < length) {
            resultBuilder.append(padChar);
        }
        return resultBuilder.toString();
    }

    private static String leftTrim(String str, int length) {
        return str.substring(str.length() - length, str.length());
    }

    public static String trimOrLeftPad(String str, int length, char padChar) {
        if (str == null) {
            str = "";
        }
        if (str.length() > length) {
            return StringUtils.rightTrim(str, length);
        }
        return StringUtils.leftPad(str, length, padChar);
    }

    public static String leftTrimOrLeftPad(String str, int length) {
        return StringUtils.leftTrimOrLeftPad(str, length, ' ');
    }

    public static String leftTrimOrLeftPad(String str, int length, char padChar) {
        if (str == null) {
            str = "";
        }
        if (str.length() > length) {
            return StringUtils.leftTrim(str, length);
        }
        return StringUtils.leftPad(str, length, padChar);
    }

    private static String rightTrim(String str, int length) {
        return str.substring(0, length);
    }

    public static String trimIfLonger(String str, int length) {
        if (str == null) {
            return null;
        }
        if (str.length() < length) {
            return str;
        }
        return StringUtils.rightTrim(str, length);
    }

    public static String center(String str, int length) {
        int i2;
        int leftSpaces = (length - str.length()) / 2;
        int rightSpaces = length - str.length() - leftSpaces;
        String result = "";
        for (i2 = 0; i2 < leftSpaces; ++i2) {
            result = result + " ";
        }
        result = result + str;
        for (i2 = 0; i2 < rightSpaces; ++i2) {
            result = result + " ";
        }
        return result;
    }

    public static String collectionToDelimitedString(Collection<?> strings, String delimiter) {
        if (strings == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator2 = strings.iterator();
        boolean addDelimiter = false;
        while (iterator2.hasNext()) {
            if (addDelimiter) {
                builder.append(delimiter);
            }
            builder.append(String.valueOf(iterator2.next()));
            addDelimiter = true;
        }
        return builder.toString();
    }

    public static String arrayToDelimitedString(Object[] strings, String delimiter) {
        if (strings == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < strings.length; ++i2) {
            if (i2 > 0) {
                builder.append(delimiter);
            }
            builder.append(String.valueOf(strings[i2]));
        }
        return builder.toString();
    }

    public static String mapToDelimitedString(Map<?, ?> data, String delimiter) {
        if (data == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object s : data.keySet()) {
            if (!first) {
                builder.append(delimiter);
            }
            first = false;
            builder.append(s).append(" -> ").append(data.get(s));
        }
        return builder.toString();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        String[] tokens = str.split("[" + delimiters + "]");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            tokens[i2] = tokens[i2].trim();
        }
        return tokens;
    }

    public static String[] delimitedStringToArray(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] tokens = str.split(Pattern.quote(delimiter));
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            tokens[i2] = tokens[i2].trim();
        }
        return tokens;
    }

    public static String intToHex(int num) {
        return StringUtils.trimOrLeftPad(Integer.toHexString(num), 8, '0');
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isNumeric(String str) {
        return str != null && str.matches("\\d*");
    }

    public static String replaceAll(String str, String originalToken, String replacementToken) {
        return str.replaceAll(Pattern.quote(originalToken), Matcher.quoteReplacement(replacementToken));
    }

    public static boolean hasLength(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String pluralize(String str, int count) {
        return count == 1 ? str : str + "s";
    }

    public static String firstMatchingGroup(String str, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String nullEmpty(String input) {
        return input == null ? "" : input;
    }

    public static String toUtf8String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String findFirstMatching(Collection<String> strs, String regex) {
        for (String str : strs) {
            if (!str.matches(regex)) continue;
            return str;
        }
        return null;
    }

    public static boolean containsMatching(Collection<String> strs, String regex) {
        return StringUtils.findFirstMatching(strs, regex) != null;
    }

    public static boolean contains(String str, String part) {
        return str != null && str.contains(part);
    }

    public static String randomString(int len) {
        return StringUtils.randomString(len, RANDOM_CHARS);
    }

    public static String randomNumbers(int len) {
        return StringUtils.randomString(len, RANDOM_NUMBERS);
    }

    public static String randomLetters(int len) {
        return StringUtils.randomString(len, RANDOM_LETTERS);
    }

    private static String randomString(int len, String randomChars) {
        StringBuilder sb = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append(randomChars.charAt(rnd.nextInt(randomChars.length())));
        }
        return sb.toString();
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static String leftPad(String original, int length, char padChar) {
        String result = original;
        while (result.length() < length) {
            result = padChar + result;
        }
        return result;
    }

    public static String collapseWhitespace(String str) {
        return str.replaceAll("\\s+", " ");
    }

    public static String[] splitIntoLines(String str) {
        return str.split("\\r?\\n");
    }
}

