/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core;

import com.boxfuse.base.types.Proxy;
import com.boxfuse.client.core.privateuse.util.PlatformTypeConfig;
import com.boxfuse.generator.config.BoxfuseConfigProperty;
import com.boxfuse.generator.config.ConfigUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BoxfuseConnectConfig {
    private static final String KEY_BASEDIR = "basedir";
    private static final String KEY_CONSOLE = "console";
    private static final String KEY_INSECURE = "insecure";
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_PROXY = "proxy";
    private static final String KEY_SECRET = "secret";
    private static final String KEY_USER = "user";
    public final BoxfuseConfigProperty<File> basedir = new BoxfuseConfigProperty(new File(System.getProperty("user.home") + "/.boxfuse"));
    public final BoxfuseConfigProperty<String> console = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<Boolean> insecure = new BoxfuseConfigProperty(Boolean.FALSE);
    public final BoxfuseConfigProperty<PlatformTypeConfig> platform = new BoxfuseConfigProperty(PlatformTypeConfig.AUTO);
    public final BoxfuseConfigProperty<Proxy> proxy = new BoxfuseConfigProperty();
    public final BoxfuseConfigProperty<String> secret = new BoxfuseConfigProperty(System.getenv("BOXFUSE_SECRET"));
    public final BoxfuseConfigProperty<String> user = new BoxfuseConfigProperty(System.getenv("BOXFUSE_USER"));

    public void configure(Map<String, String> cfg) {
        this.basedir.set((File[])new File[]{ConfigUtils.fileOf(cfg.get(KEY_BASEDIR))});
        this.console.set((String[])new String[]{cfg.get(KEY_CONSOLE)});
        this.insecure.set((Boolean[])new Boolean[]{ConfigUtils.booleanOf(cfg, KEY_INSECURE)});
        this.platform.set((PlatformTypeConfig[])new PlatformTypeConfig[]{PlatformTypeConfig.of(cfg.get(KEY_PLATFORM))});
        this.proxy.set((Proxy[])new Proxy[]{Proxy.of(cfg.get(KEY_PROXY))});
        this.secret.set((String[])new String[]{cfg.get(KEY_SECRET)});
        this.user.set((String[])new String[]{cfg.get(KEY_USER)});
    }

    public Map<String, String> toMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.basedir.isSet()) {
            map.put(KEY_BASEDIR, this.basedir.getConfigured().getAbsolutePath());
        }
        if (this.console.isSet()) {
            map.put(KEY_CONSOLE, this.console.getConfigured());
        }
        if (this.insecure.isSet()) {
            map.put(KEY_INSECURE, this.insecure.getConfigured().toString());
        }
        if (this.platform.isSet()) {
            map.put(KEY_PLATFORM, this.platform.getConfigured().getName());
        }
        if (this.proxy.isSet()) {
            map.put(KEY_PROXY, this.proxy.getConfigured().getUrl());
        }
        if (this.secret.isSet()) {
            map.put(KEY_SECRET, this.secret.getConfigured());
        }
        if (this.user.isSet()) {
            map.put(KEY_USER, this.user.getConfigured());
        }
        return map;
    }

    public static void removeAllValidKeys(Set<String> keys2) {
        keys2.removeAll(Arrays.asList(KEY_BASEDIR, KEY_CONSOLE, KEY_INSECURE, KEY_PLATFORM, KEY_PROXY, KEY_SECRET, KEY_USER));
    }
}

