/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.cloudwatchlogs;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.HttpUtils;
import com.boxfuse.client.core.internal.cloudwatchlogs.CloudwatchLogsHttpLogs;
import com.boxfuse.client.core.internal.console.Console;
import com.boxfuse.generator.config.LogsFilters;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class CloudwatchLogsAwsLogs
extends CloudwatchLogsHttpLogs {
    protected final Console console;

    public CloudwatchLogsAwsLogs(Console console, EnvName environmentName, LogsFilters filters, LogsLayout layout, Proxy proxy, boolean insecure) {
        super(console.getOwner(), environmentName, filters, layout, proxy, insecure);
        this.console = console;
    }

    @Override
    protected HttpPost createRequest(Map<String, Object> data) {
        Map<String, Object> result = this.console.cloudwatchlogs(this.env, (AppCoordinates)this.filters.get((Object)LogsFieldName.APP), data);
        String uri = (String)result.get("uri");
        String contentBase64 = (String)result.get("content");
        Map headers = (Map)result.get("headers");
        HttpPost post = new HttpPost(uri);
        post.setConfig(HttpUtils.createRequestConfigBuilder(null).setConnectTimeout(2000).setSocketTimeout(30000).build());
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if ("Content-Length".equals(headerName)) continue;
            post.addHeader((Header)new BasicHeader(headerName, (String)entry.getValue()));
        }
        post.setEntity((HttpEntity)new ByteArrayEntity(ByteArrayUtils.fromBase64(contentBase64), ContentType.create((String)"application/x-amz-json-1.1")));
        return post;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchLogsAwsLogs that = (CloudwatchLogsAwsLogs)o;
        return this.console.equals(that.console);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.console.hashCode();
        return result;
    }
}

