/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.dev;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.ThreadUtils;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevAgent.class);
    private final File jarFile;
    private final File pidFile;
    private final File portFile;
    private final File dbFile;
    private boolean running;
    private Port port;
    private Integer pid;

    public DevAgent(File workDir) {
        File dir = new File(workDir, "DevAgent");
        ShellUtils.mkdir(dir);
        this.jarFile = new File(dir, "boxfuse-dev-agent.jar");
        this.pidFile = new File(dir, "boxfuse-dev-agent.pid");
        this.portFile = new File(dir, "boxfuse-dev-agent.port");
        this.dbFile = new File(dir, "boxfuse-dev-agent.db.mv.db");
        this.refresh();
    }

    public Port start() {
        this.refresh();
        if (this.running) {
            return this.port;
        }
        if (this.dbFile.exists()) {
            ShellUtils.deleteFile(this.dbFile);
        }
        IOUtils.copy(IOUtils.copyToByteArray("boxfuse-dev-agent.jar"), this.jarFile);
        String command = System.getProperty("java.home") + "/bin/java";
        if (OSUtils.runningOnWindows()) {
            command = command + "w.exe";
        }
        ShellUtils.execCommandAsync(command, "-jar", this.jarFile.getAbsolutePath());
        Date timeoutDate = DateUtils.addSeconds(new Date(), 30);
        while (!this.running && new Date().before(timeoutDate)) {
            ThreadUtils.sleep(200L);
            this.refresh();
        }
        if (!this.running) {
            LOGGER.warn("Timeout waiting for Dev Agent to start. Instance logs may not be displayed correctly.");
            return null;
        }
        LOGGER.debug("Started Dev Agent");
        return this.port;
    }

    public void stop() {
        this.refresh();
        if (this.running) {
            this.kill();
            LOGGER.debug("Stopped Dev Agent");
            this.refresh();
        }
    }

    public Port getPort() {
        return this.port;
    }

    private void refresh() {
        this.running = false;
        this.port = null;
        this.pid = null;
        String pidStr = IOUtils.copyToString(this.pidFile);
        if (pidStr == null) {
            return;
        }
        try {
            this.pid = Integer.parseInt(pidStr);
        }
        catch (NumberFormatException e) {
            ShellUtils.deleteFile(this.pidFile);
            return;
        }
        this.running = ShellUtils.isRunning(this.pid);
        if (!this.running) {
            this.pid = null;
            ShellUtils.deleteFile(this.pidFile);
            ShellUtils.deleteFile(this.portFile);
            return;
        }
        try {
            this.port = Port.of(IOUtils.copyToString(this.portFile));
        }
        catch (Exception e) {
            this.kill();
            this.refresh();
        }
    }

    private void kill() {
        ShellUtils.deleteFile(this.portFile);
        try {
            ShellUtils.kill(this.pid);
            ShellUtils.deleteFile(this.pidFile);
        }
        catch (BoxfuseException e) {
            LOGGER.warn("Unable to kill Boxfuse Dev Agent: " + e.getMessage());
        }
    }
}

