/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local;

import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.client.core.internal.console.Console;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.client.core.internal.platform.local.LocalPlatform;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformHealth;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVInstallation;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVPlatform;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxInstallation;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxPlatform;
import com.boxfuse.client.core.privateuse.util.PlatformTypeConfig;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.repository.Repository;
import java.io.File;

public class LocalPlatformFactory {
    private VirtualBoxPlatform virtualBoxPlatform;
    private HyperVPlatform hyperVPlatform;
    private final File workDir;
    private final Repository repository;
    private final DevAgent devAgent;
    private final Console console;
    private final PlatformTypeConfig platform;

    public LocalPlatformFactory(File workDir, Repository repository, DevAgent devAgent, Console console, PlatformTypeConfig platform) {
        this.workDir = workDir;
        this.repository = repository;
        this.devAgent = devAgent;
        this.console = console;
        this.platform = platform;
    }

    public LocalPlatform<?> getLocalPlatform(BoxfuseConfig config) {
        if (this.platform == PlatformTypeConfig.VIRTUALBOX || this.platform == PlatformTypeConfig.AUTO && VirtualBoxInstallation.get().getHealth() == LocalPlatformHealth.OK) {
            return this.getVirtualBoxPlatform(config);
        }
        if (this.platform == PlatformTypeConfig.HYPERV || this.platform == PlatformTypeConfig.AUTO && HyperVInstallation.get().getHealth() == LocalPlatformHealth.OK) {
            return this.getHyperVPlatform(config);
        }
        return this.getVirtualBoxPlatform(config);
    }

    private HyperVPlatform getHyperVPlatform(BoxfuseConfig config) {
        if (this.hyperVPlatform == null) {
            LogsLayout logsLayout = config.logs.layout.get();
            this.hyperVPlatform = new HyperVPlatform(this.workDir, this.repository, this.devAgent, logsLayout, config.windows.user.get(), config.windows.password.get());
        }
        return this.hyperVPlatform;
    }

    private VirtualBoxPlatform getVirtualBoxPlatform(BoxfuseConfig config) {
        if (this.virtualBoxPlatform == null) {
            LogsLayout logsLayout = config.logs.layout.get();
            Boolean useNatNetwork = config.virtualboxNatnetwork.get();
            this.virtualBoxPlatform = new VirtualBoxPlatform(this.workDir, this.repository, this.devAgent, logsLayout, this.console.isVirtualBoxOK(), (boolean)useNatNetwork);
        }
        return this.virtualBoxPlatform;
    }
}

