/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.virtualbox;

import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.OSUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformHealth;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualBoxInstallation {
    private final Version version;
    private final String rawVersion;
    private final LocalPlatformHealth health;
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualBoxInstallation.class);
    static final String EXECUTABLE = OSUtils.runningOnWindows() ? "VBoxManage.exe" : "VBoxManage";
    private static final String vboxManage = VirtualBoxInstallation.findVBoxManageBinary(EXECUTABLE);
    static final Version MINIMUM_SUPPORTED_VERSION = new Version("5.0");
    private static VirtualBoxInstallation virtualBoxInstallation;

    private VirtualBoxInstallation(Version version, String rawVersion, LocalPlatformHealth health) {
        this.version = version;
        this.rawVersion = rawVersion;
        this.health = health;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getRawVersion() {
        return this.rawVersion;
    }

    public LocalPlatformHealth getHealth() {
        return this.health;
    }

    public static VirtualBoxInstallation get() {
        if (virtualBoxInstallation == null) {
            virtualBoxInstallation = VirtualBoxInstallation.computeVirtualBoxInstallationDetails();
        }
        return virtualBoxInstallation;
    }

    private static VirtualBoxInstallation computeVirtualBoxInstallationDetails() {
        if (vboxManage == null) {
            return new VirtualBoxInstallation(null, null, LocalPlatformHealth.NOT_INSTALLED);
        }
        try {
            String rawVersion = ShellUtils.execCommand(vboxManage, "-v").trim();
            return VirtualBoxInstallation.getVirtualBoxInstallationDetailsForRawVersion(rawVersion);
        }
        catch (Exception e) {
            return new VirtualBoxInstallation(null, null, LocalPlatformHealth.BROKEN);
        }
    }

    static VirtualBoxInstallation getVirtualBoxInstallationDetailsForRawVersion(String rawVersion) {
        Version version;
        try {
            version = new Version(rawVersion.substring(0, 3));
        }
        catch (Exception e) {
            return new VirtualBoxInstallation(null, rawVersion, LocalPlatformHealth.BROKEN);
        }
        int compareWith42 = version.compareTo(MINIMUM_SUPPORTED_VERSION);
        if (compareWith42 < 0) {
            return new VirtualBoxInstallation(version, rawVersion, LocalPlatformHealth.OUTDATED);
        }
        return new VirtualBoxInstallation(version, rawVersion, LocalPlatformHealth.OK);
    }

    static String getVboxManage() {
        return vboxManage;
    }

    static String findVBoxManageBinary(String executable) {
        String[] searchDirs = OSUtils.runningOnWindows() ? new String[]{System.getenv("VBOX_MSI_INSTALL_PATH"), System.getenv("VBOX_INSTALL_PATH"), System.getenv("ProgramFiles") + "\\Oracle\\VirtualBox"} : new String[]{"/usr/bin", "/usr/local/bin"};
        String vboxManage = ShellUtils.findCommandInDirs(executable, searchDirs);
        if (vboxManage == null && new File(executable).canExecute()) {
            LOGGER.debug("Found " + executable + " on PATH");
            return executable;
        }
        return vboxManage;
    }

    public String getInfo() {
        switch (this.health) {
            case OK: {
                return this.getRawVersion();
            }
            case OUTDATED: {
                return this.getRawVersion() + " (" + (Object)((Object)this.health) + ") -> Update to the latest version from https://www.virtualbox.org";
            }
            case BROKEN: {
                return (Object)((Object)this.health) + " -> Execute " + EXECUTABLE + " -v for details";
            }
        }
        return (Object)((Object)this.health) + " -> Install the latest version from https://www.virtualbox.org";
    }
}

