/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.virtualbox;

import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.Path;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.client.core.internal.platform.AbstractInstance;
import com.boxfuse.client.core.internal.platform.local.virtualbox.VirtualBoxPlatform;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.image.Image;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class VirtualBoxInstance
extends AbstractInstance<VirtualBoxPlatform> {
    private final boolean legacyNetworking;

    VirtualBoxInstance(VirtualBoxPlatform platform, boolean legacyNetworking, Image image, DiskImage diskImage, InstanceId id, CpuCount cpus, RamMB ram, Date launchTime, Logs bootLogs, Logs appLogs, File workDir, Map<PortName, Port> ports, Path payloadPath) {
        super(platform, image, diskImage, id, cpus, ram, launchTime, bootLogs, appLogs, workDir, ports, payloadPath);
        this.legacyNetworking = legacyNetworking;
    }

    @Override
    public IpAddress getIpAddress() {
        return IpAddress.LOCALHOST;
    }

    @Override
    public void destroy() {
        ((VirtualBoxPlatform)this.platform).killVM(this.id.getId());
        if (!this.legacyNetworking) {
            ((VirtualBoxPlatform)this.platform).discardObsoleteNatNetworkPortForwardingRules();
        }
        String storageCtlName = ((VirtualBoxPlatform)this.platform).computeStorageCtlName(this.id.getId());
        ((VirtualBoxPlatform)this.platform).closeAndDeleteHdd(this.id.getId(), storageCtlName, this.diskImage.getMainFile(), 0);
        ((VirtualBoxPlatform)this.platform).closeAndDeleteHdd(this.id.getId(), storageCtlName, ((VirtualBoxPlatform)this.platform).getTmpDiskFile(this.workDir), 1);
        ((VirtualBoxPlatform)this.platform).closeAndDeleteDvd(this.id.getId(), storageCtlName, ((VirtualBoxPlatform)this.platform).getEnvironmentIsoFile(this.workDir));
        ((VirtualBoxPlatform)this.platform).destroyVM(this.id.getId());
    }
}

