/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class DropwizardConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardConfig.class);
    private final Map<PortName, Port> ports = new HashMap<PortName, Port>();
    private final Path payloadPath;
    private final Path healthcheckPath;

    DropwizardConfig(String yaml) {
        String rootPath;
        String applicationContextPath;
        Map yml = (Map)new Yaml().load(yaml);
        if (yml == null) {
            throw new BoxfuseException("Invalid Dropwizard config: " + yaml);
        }
        Map server = (Map)yml.get("server");
        String adminContextPath = "";
        if (server != null) {
            applicationContextPath = (String)server.get("applicationContextPath");
            adminContextPath = (String)server.get("adminContextPath");
            if ("simple".equals(server.get("type"))) {
                Map connector;
                if (applicationContextPath == null) {
                    applicationContextPath = "/application";
                }
                if (adminContextPath == null) {
                    adminContextPath = "/admin";
                }
                if ((connector = (Map)server.get("connector")) != null) {
                    this.registerPort(this.ports, connector, "");
                } else {
                    this.ports.put(PortName.HTTP, Port.of("8080/http"));
                }
            } else {
                List applicationConnectors;
                if (applicationContextPath == null) {
                    applicationContextPath = "";
                }
                if (adminContextPath == null) {
                    adminContextPath = "";
                }
                if ((applicationConnectors = (List)server.get("applicationConnectors")) != null) {
                    for (Map applicationConnector : applicationConnectors) {
                        this.registerPort(this.ports, applicationConnector, "");
                    }
                } else {
                    this.ports.put(PortName.HTTP, Port.of("8080/http"));
                }
                List adminConnectors = (List)server.get("adminConnectors");
                if (adminConnectors != null) {
                    for (Map adminConnector : adminConnectors) {
                        this.registerPort(this.ports, adminConnector, "admin-");
                    }
                } else {
                    this.ports.put(PortName.ADMIN_HTTP, Port.of("8081/http"));
                }
            }
            rootPath = (String)server.get("rootPath");
            if (rootPath == null) {
                rootPath = "/";
            }
            if (!rootPath.startsWith("/")) {
                rootPath = "/" + rootPath;
            }
            if (!rootPath.endsWith("/")) {
                rootPath = rootPath + "/";
            }
        } else {
            applicationContextPath = "";
            rootPath = "/";
            this.ports.put(PortName.HTTP, Port.of("8080/http"));
            this.ports.put(PortName.ADMIN_HTTP, Port.of("8081/http"));
        }
        if ("/".equals(applicationContextPath)) {
            applicationContextPath = "";
        }
        this.payloadPath = Path.of(applicationContextPath + rootPath);
        this.healthcheckPath = Path.of(adminContextPath + "/healthcheck");
    }

    private void registerPort(Map<PortName, Port> ports, Map<String, Object> applicationConnector, String prefix) {
        String type = (String)applicationConnector.get("type");
        Object port = applicationConnector.get("port");
        if (type != null) {
            if (port == null) {
                port = 8080;
            } else if (!(port instanceof Integer)) {
                LOGGER.warn("Skipping invalid port definition in boxfuse.yml (" + type + " -> " + port + "): port should be a number between 1 and 65535");
                return;
            }
            try {
                ports.put(PortName.of(prefix + type), Port.of(port + "/" + type));
            }
            catch (Exception e) {
                LOGGER.warn("Skipping invalid port definition in boxfuse.yml (" + type + " -> " + port + "): " + e.getMessage());
            }
        }
    }

    public Map<PortName, Port> getPorts() {
        return this.ports;
    }

    public Path getHealthcheckPath() {
        return this.healthcheckPath;
    }

    public Path getPayloadPath() {
        return this.payloadPath;
    }
}

