/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.payload;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.generator.builder.ramdisk.RamDiskPayload;
import com.boxfuse.generator.payload.PhysicalPayload;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class DirectoryPayload
extends PhysicalPayload {
    private final long payloadSize;
    protected final boolean live;

    public DirectoryPayload(File dir, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(dir, entries);
        this.payloadSize = payloadSize;
        this.live = live;
        if (!dir.isDirectory()) {
            throw new BoxfuseException("Invalid Payload (not a directory): " + dir.getAbsolutePath());
        }
        if (!(this instanceof RamDiskPayload)) {
            throw new BoxfuseException("Unsupported Payload: " + dir.getAbsolutePath());
        }
    }

    @Override
    public long size() {
        return this.payloadSize;
    }

    private void collectFileInfo(Map<String, String> fileInfo, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                fileInfo.put(file.getAbsolutePath(), ":" + file.lastModified());
                this.collectFileInfo(fileInfo, file);
                continue;
            }
            fileInfo.put(file.getAbsolutePath(), file.length() + ":" + file.lastModified());
        }
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public int getChecksum() {
        if (this.live) {
            return 0;
        }
        HashMap<String, String> fileInfo = new HashMap<String, String>();
        this.collectFileInfo(fileInfo, this.getFile());
        return fileInfo.hashCode();
    }
}

