/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.payload;

import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.generator.payload.PhysicalPayload;
import java.io.File;
import java.util.Map;
import java.util.zip.CRC32;

public abstract class FilePayload
extends PhysicalPayload {
    protected final byte[] bytes;
    private final int checksum;

    public FilePayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, entries);
        this.bytes = bytes;
        this.checksum = FilePayload.calculateChecksum(bytes);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public long size() {
        return this.bytes.length;
    }

    @Override
    public int getChecksum() {
        return this.checksum;
    }

    private static int calculateChecksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)crc32.getValue();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.checksum;
        return result;
    }
}

