/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static Map<String, Object> jsonToMap(String json) {
        return JsonUtils.toMap(json, new TypeReference<LinkedHashMap<String, Object>>(){});
    }

    public static Map<String, String> jsonToStringMap(String json) {
        return JsonUtils.toMap(json, new TypeReference<LinkedHashMap<String, String>>(){});
    }

    private static <T> T toMap(String json, TypeReference<T> typeReference) {
        if (json == null) {
            return null;
        }
        ObjectMapper mapper = JsonUtils.createObjectMapper();
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to parse JSON: " + json, e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        return mapper;
    }

    public static <T> T toObject(String json, Class<T> typeReference) {
        if (json == null) {
            return null;
        }
        ObjectMapper mapper = JsonUtils.createObjectMapper();
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to parse JSON (" + e.getMessage() + "): " + json, e);
        }
    }

    public static String mapToJson(Map<String, Object> map) {
        return JsonUtils.toJson(map);
    }

    public static String stringMapToJson(Map<String, String> map) {
        return JsonUtils.toJson(map);
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = JsonUtils.createObjectMapper();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to write JSON (" + e.getMessage() + "): " + obj, e);
        }
    }
}

