/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarDirectoyPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.ManifestUtils;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootDirectoryPayload
extends JarDirectoyPayload
implements SpringBootPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootDirectoryPayload.class);
    private String libDir;
    private final PayloadType payloadType;
    private final boolean springBoot1;

    public static boolean supports(PayloadFormat format, Map<String, PayloadEntry> entries) {
        return PayloadFormat.DIRECTORY == format && SpringBootDirectoryPayload.containsSpringBootJars(entries);
    }

    private static boolean containsSpringBootJars(Map<String, PayloadEntry> entries) {
        for (String entry : entries.keySet()) {
            if (!entry.startsWith("lib/spring-boot-") && !entry.startsWith("BOOT-INF/lib/spring-boot-") && !entry.startsWith("WEB-INF/lib/spring-boot-")) continue;
            return true;
        }
        return false;
    }

    public SpringBootDirectoryPayload(File file, long payloadSize, Map<String, PayloadEntry> entries, boolean live) {
        super(file, payloadSize, entries, live);
        if (StringUtils.containsMatching(entries.keySet(), (String)"WEB-INF/lib/spring-boot-.*\\.jar")) {
            this.springBoot1 = true;
            LOGGER.debug("Detected Spring Boot 1.4 exploded war");
            this.classesDir = "WEB-INF/classes/";
            this.libDir = "WEB-INF/lib/";
        } else if (StringUtils.containsMatching(entries.keySet(), (String)"BOOT-INF/lib/spring-boot-.*\\.jar")) {
            if (StringUtils.containsMatching(entries.keySet(), (String)"BOOT-INF/lib/spring-boot-2.*\\.jar")) {
                this.springBoot1 = false;
                LOGGER.debug("Detected Spring Boot 2.0 or newer");
            } else {
                this.springBoot1 = true;
                LOGGER.debug("Detected Spring Boot 1.4 or newer");
            }
            this.classesDir = "BOOT-INF/classes/";
            this.libDir = "BOOT-INF/lib/";
        } else {
            this.springBoot1 = true;
            LOGGER.debug("Detected Spring Boot 1.3 or older");
            this.classesDir = "";
            this.libDir = "lib/";
        }
        this.payloadType = this.containsGrailsJars() ? PayloadType.GRAILS : (this.containsJHipster() ? PayloadType.JHIPSTER : PayloadType.SPRINGBOOT);
    }

    @Override
    public PayloadType getType() {
        return this.payloadType;
    }

    private boolean containsGrailsJars() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + "grails-core-.*\\.jar"));
    }

    private boolean containsJHipster() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.classesDir + ".*/config/JHipsterProperties.class"));
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || !StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + dbType.getJdbcDriverJarRegex()))) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        super.installInto(ramDisk, baseDir);
        for (String entry : this.entries.keySet()) {
            if (!entry.startsWith(this.classesDir) || entry.substring(this.classesDir.length()).contains("/") || !entry.endsWith(".jks") && !entry.endsWith(".keystore")) continue;
            byte[] entryBytes = IOUtils.copyToByteArray((File)new File(this.file.getAbsolutePath() + "/" + entry));
            ramDisk.createFile("app/" + entry, false, entryBytes);
        }
    }

    @Override
    public boolean isSpringBoot1() {
        return this.springBoot1;
    }

    @Override
    public boolean hasActuator() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + "spring-boot-actuator-.*\\.jar"));
    }

    @Override
    public String getConfigFile(String name) {
        return IOUtils.copyToString((File)new File(this.file.getAbsolutePath() + "/" + this.classesDir + name));
    }

    @Override
    public String getClassPath() {
        return "\"/app:/app/" + this.libDir + "*:/app/" + this.libDir.substring(0, this.libDir.length() - 1) + "-provided/*:/app/" + this.classesDir + "\"";
    }

    @Override
    public String getMainClass() {
        return ManifestUtils.getAttributeFromJarManifest(this.getManifest(), "Start-Class");
    }
}

