/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.tomcat;

import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.JvmRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatRamDiskBuilder<P extends TomcatPayload>
extends JvmRamDiskBuilder<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatRamDiskBuilder.class);
    private static final String WEBAPPS_DIR = "tomcat/webapps";
    protected static final String DESTINATION = "tomcat/webapps/ROOT";
    static final String CUSTOM_JRE_LOCATION = "WEB-INF/jre";
    static final String NATIVE_LOCATION = "WEB-INF/native";
    static final String KEYSTORE_LOCATION = "WEB-INF/keystore.jks";
    static final String SERVER_XML_LOCATION = "WEB-INF/server.xml";
    static final String SYSCTL_CONF_LOCATION = "WEB-INF/sysctl.conf";
    private static final String WEB_XML_TOMCAT_7 = "<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee\n                      http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"\n         version=\"3.0\">";
    private static final String WEB_XML_TOMCAT_8 = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee\n                      http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\"\n  version=\"3.1\">";
    private static final String WEB_XML_SSL_REDIRECT = "<security-constraint>\n  <web-resource-collection>\n    <web-resource-name>Protected Context</web-resource-name>\n    <url-pattern>/*</url-pattern>\n  </web-resource-collection>\n  <user-data-constraint>\n    <transport-guarantee>CONFIDENTIAL</transport-guarantee>\n  </user-data-constraint>\n</security-constraint>";
    private static final String HTTP_CONNECTOR = "<Connector port=\"${BOXFUSE_PORTS_HTTP}\" connectionTimeout=\"20000\"/>";
    private static final String HTTP_CONNECTOR_WITH_REDIRECT = "<Connector port=\"${BOXFUSE_PORTS_HTTP}\" redirectPort=\"${BOXFUSE_PORTS_HTTPS__REDIRECT}\" connectionTimeout=\"20000\"/>";
    private static final String HTTPS_CONNECTOR = "<Connector port=\"${BOXFUSE_PORTS_HTTPS}\" scheme=\"https\" secure=\"true\" SSLEnabled=\"true\" sslProtocol=\"TLS\" keystoreFile=\"/tomcat/conf/keystore.jks\" keystorePass=\"%s\"/>";
    protected static final String TOMCAT_INCLUDE_REGEX = "^bin/.+\\.jar$|^conf/catalina\\..+$|^conf/logging\\.properties$|^lib/.+\\.jar$|LICENSE|NOTICE";
    protected final Component tomcatComponent = this.getTomcatComponent();

    public TomcatRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
        this.components.add(this.tomcatComponent);
    }

    protected Component getTomcatComponent() {
        return this.getComponent(ComponentId.TOMCAT);
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        Map<PortName, Port> ports = this.spec.getPorts();
        if (ports.get(PortName.HTTP) == null && ports.get(PortName.HTTPS) == null) {
            Port port;
            PortName portName = this.spec.getTlsType() == TlsType.ACM ? PortName.HTTPS : PortName.HTTP;
            Port port2 = port = this.spec.getTlsType() == TlsType.ACM ? Port.HTTPS : Port.HTTP;
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured " + portName + " port to " + port);
            }
            ports.put(portName, port);
        }
        super.doAdjustSpecBasedOnConfig();
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        this.ramDisk.installZipArchive(this.tomcatComponent.getBytes(), "tomcat/", this.getBaseArchiveDirPrefix() + this.tomcatComponent.getVersion(), this.getIncludeRegex(), false, null);
        this.ramDisk.createSymLink("tomcat/temp", "/tmp");
        byte[] keyStore = ((TomcatPayload)this.payload).getKeyStore();
        String keyStorePass = null;
        if (keyStore != null) {
            LOGGER.debug("Detected user-supplied KeyStore");
            keyStorePass = "changeit";
        } else if (this.spec.getTlsType() == TlsType.ACM) {
            LOGGER.debug("Using automatically created KeyStore");
            keyStore = IOUtils.copyToByteArray((String)"generator/selfsigned/boxfuse-selfsigned.jks");
            keyStorePass = "boxfuse-selfsigned";
        }
        Port httpsPort = this.spec.getPorts().get(PortName.HTTPS);
        if (httpsPort != null && keyStore == null) {
            throw new BoxfuseException("HTTPS port specified (" + httpsPort.getNumber() + "), but KeyStore is missing. Place the KeyStore with a single certificate under " + KEYSTORE_LOCATION + " (password: changeit) and Boxfuse will automatically configure Tomcat to use it.");
        }
        if (keyStore != null) {
            this.ramDisk.createFile("tomcat/conf/keystore.jks", false, keyStore);
        }
        ((TomcatPayload)this.payload).installInto(this.ramDisk, DESTINATION);
        Port httpPort = this.spec.getPorts().get(PortName.HTTP);
        if (httpPort == null && httpsPort == null) {
            throw new BoxfuseException("Both the http and the https ports are disabled. You must specify at least one for Tomcat to work.");
        }
        this.installServerXml(keyStorePass, httpPort, httpsPort);
        String webXmlOpenTag = this.isTomcat7() ? WEB_XML_TOMCAT_7 : WEB_XML_TOMCAT_8;
        String redirect = httpsPort != null && httpPort != null ? WEB_XML_SSL_REDIRECT : "";
        String webXml = Template.process((String)"generator/tomcat/web.xml", (Object[])new Object[]{webXmlOpenTag, redirect});
        this.ramDisk.createFile("tomcat/conf/web.xml", false, webXml);
    }

    protected String getBaseArchiveDirPrefix() {
        return "apache-tomcat-";
    }

    protected String getIncludeRegex() {
        return TOMCAT_INCLUDE_REGEX;
    }

    private void installServerXml(String keyStorePass, Port httpPort, Port httpsPort) throws IOException {
        byte[] serverXml = ((TomcatPayload)this.payload).getServerXml();
        if (serverXml == null) {
            LOGGER.debug("Using automatically created server.xml");
            String connectors = TomcatRamDiskBuilder.createConnectorsXml(httpsPort != null, keyStorePass, httpPort != null);
            String serverXmlTemplate = this.getServerXmlTemplate();
            serverXml = Template.process((String)serverXmlTemplate, (Object[])new Object[]{connectors}).getBytes(StandardCharsets.UTF_8);
        } else {
            LOGGER.debug("Detected user-supplied server.xml");
        }
        this.ramDisk.createFile("tomcat/conf/server.xml", false, serverXml);
    }

    protected boolean isTomcat7() {
        return this.tomcatComponent.getVersion().getVersion().startsWith("7");
    }

    protected String getServerXmlTemplate() {
        return "generator/tomcat/server.xml";
    }

    @Override
    protected void installCustomJRE() throws IOException {
        this.ramDisk.createSymLink("jre", "/tomcat/webapps/ROOT/WEB-INF/jre");
    }

    @Override
    protected void installNativeBinariesAndLibs() throws IOException {
        this.ramDisk.createSymLink("native", "/tomcat/webapps/ROOT/WEB-INF/native");
    }

    private static String createConnectorsXml(boolean https, String keyStorePass, boolean http) {
        String connectors = "";
        if (https) {
            connectors = connectors + String.format(HTTPS_CONNECTOR, keyStorePass);
            if (http) {
                connectors = connectors + HTTP_CONNECTOR_WITH_REDIRECT;
            }
        } else {
            connectors = connectors + HTTP_CONNECTOR;
        }
        return connectors;
    }

    @Override
    protected String getStartDir() {
        return "/tomcat";
    }

    @Override
    protected String computeJvmExtraArgs() {
        return "-cp \"/tomcat/bin/*\"";
    }

    @Override
    protected void adjustEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        this.putIfAbsent(envVars, EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.asIs((String)"org.apache.catalina.startup.Bootstrap"));
    }
}

